#!/usr/bin/env python
# -*- coding: UTF-8 -*-

##############   Originaldatei: Pressure_20151217_2255.py   #############

import spidev, time


#	*******   Subroutinen definieren   ***********
def read(reg):
    return reg | 0x80

def write(reg):
    return reg & 0x7f

def komplement2(x):
    return -1* ((x-1)^0xffff)

def DatZeit():
    AktZeit= time.localtime()
    AktDat="%04i%02i%02i" % (int(AktZeit[0]), int(AktZeit[1]), int(AktZeit[2]))
    return AktDat

def LtoA(x):#	******  long in ASCII umwandeln
    divH= divmod(x, 256<<8)
    divL= divmod(divH[1], 256)
#	print"\t",divH, divL
    return int(divH[0]), int(divL[0]), int(divL[1])



def messung(spi, AC1,AC2,AC3,AC4,AC5,AC6, B1,B2, MB,MC,MD):
    #####   Controllregister zur Temp-Messung setzen (Reg f4h = 2eh)   #####
    ret_spi= spi.xfer2([write(0xf4), 0x2e])
    time.sleep(.01)

    ############   acd_out MSG lesen (Reg f6h/ 0f7h)  ##############
    nix, ret_MSB, ret_LSB= spi.xfer2([read(0xf6), 0,0])
    UT= ret_MSB << 8 | ret_LSB

    ######  Controllregister zur Druckmessung setzen (Reg f4h = 34h)  ######
    oss=0
    ret_spi= spi.xfer2([write(0xf4), 0x34 | (oss << 6)])
    time.sleep(.01)

    ###########  acd_out lesen (Reg f6, f7,f8h) ########################
    nix, ret_MSB, ret_LSB, ret_XLSB = spi.xfer2([read(0xf6),0,0,0])
    UP= (ret_MSB << 16 | ret_LSB<< 8 | ret_XLSB) >> (8- oss)

    ############ Temp calibrieren  ##############
    X1= (UT - AC6)* AC5/ 2** 15
    X2= MC * 2**11 / (X1+ MD)
    B5= X1+X2
    T= (B5 + 8) / 2**4

    ############ Druck calibrieren ##############
    if 1==2:	############   NUR ZUM TEST !!!!!!!!
        B5=2399
        B2=4
        AC2=-72
        AC1=408
        AC3=-14383
        B1=6190
        AC4= 32741
        UP= 23843

    B6= B5- 4000
    X1= (B2* (B6* B6/ 2**12))/2**11
    X2= AC2* B6/ 2**11
    X3= X1+ X2
    B3=(((AC1* 4+ X3)<< oss)+ 2)/ 4
    X1= AC3* B6/ 2**13
    X2= (B1* (B6* B6/ 2**12))/ 2**16
    X3= ((X1+ X2)+ 2)/ 2**2
    B4= AC4* (X3+ 32768)/ 2**15
    B7= (UP- B3)* (50000 >> oss)
    if B7 < 0x80000000:
        p=(B7* 2)/ B4
    else:
        p= (B7/ B4)* 2
    X1= int((p/ float(2**8))* (p/ float(2**8)))
    X1= (X1* 3038)/ 2**16
    X2= (-7357* p)/ 2**16
    p= p+ (X1+ X2+ 3791)/ 2**4
    return T, p




# ============================   HAUPTPROGRAMM   ==========================

# ------------------   Vorbereitungen   -------------------

#######    SPI vorbereiten   ######
spi= spidev.SpiDev()
spi.open(0,0)

########   ID lesen   #######
reg= 0xd0
nix, ret_ID= spi.xfer2([read(reg),0])
if ret_ID != 0x55:
    print"Zahl in ID-Register falsch", hex(ret_ID), "statt 55h"
    quit(1)
#print"ID:", ret_ID, hex(ret_ID)

########   Calibration Data lesen (AC1 bis MD) 
regString= [read(0xaa)]
for x in range (0, 22):
    regString.append(0)
Cdata= spi.xfer2(regString)

AC1= Cdata[1] << 8 | Cdata[2]
if AC1 & 0x8000: AC1= komplement2(AC1)

AC2= Cdata[3] << 8 | Cdata[4]
if AC2 & 0x8000: AC2= komplement2(AC2)

AC3= Cdata[5] << 8 | Cdata[6]
if AC3 & 0x8000: AC3= komplement2(AC3)

AC4= Cdata[7] << 8 | Cdata[8]

AC5= Cdata[9] << 8 | Cdata[10]

AC6= Cdata[11] << 8 | Cdata[12]

B1= Cdata[13] << 8 | Cdata[14]
if B1 & 0x8000: B1= komplement2(B1)

B2= Cdata[15] << 8 | Cdata[16]
if B2 & 0x8000: B2= komplement2(B2)

MB= Cdata[17] << 8 | Cdata[18]
if MB & 0x8000: MB= komplement2(MB)

MC= Cdata[19] << 8 | Cdata[20]
if MC & 0x8000: MC= komplement2(MC)

MD= Cdata[21] << 8 | Cdata[22]
if MD & 0x8000: MD= komplement2(MD)




# ============================   Berechnung   ==========================

Pause= 2.0	#	1.5#	Sekunden zwischen Messzyklen

display=True
messwerte=[]

istTag= time.localtime()[2]
AktDat= DatZeit()
print"AktDat:", AktDat
OnS= open("./Data_TempDruck_" + AktDat +".bin","ab")

x=0
run=True
Flush=True
while run:
    try:
        x+= 1
        temp, druck= messung(spi, AC1,AC2,AC3,AC4,AC5,AC6, B1,B2, MB,MC,MD)
        Lzeit= time.localtime()
        zeitA= Lzeit
        if display:
            print"Temperatur:   %5.1f °C" % (temp/10.0),
            print"Luftdruck:  %8.2f hPa" % (druck/100.0),
#			zeitA= time.localtime()
            zeit= str(zeitA[3])+ ":"+ str(zeitA[4])+ ":" + str(zeitA[5])
            print"\tZeit:", zeit, "\tMessung#: ", x
            OnS.write(chr(zeitA[3])+ chr(zeitA[4])+ chr(zeitA[5]))#	Zeit (bin)
#		messwerte.append((zeit,temp,druck))

            ret_LtoA= LtoA(temp)#		Temperatur (bin)
#		print"ret:", ret_LtoA
            for wert in ret_LtoA: OnS.write(chr(wert))

            ret_LtoA= LtoA(druck)#		Druck (bin)
            for wert in ret_LtoA: OnS.write(chr(wert))
            #OnS.write("\n")
            time.sleep(Pause)
        else:
            print"Messung# :", x

#	    Lzeit= time.localtime()
        if Lzeit[2] != istTag:
            AktDat= DatZeit()
            OnS.close()
            OnS= open("./Data_TempDruck_" + AktDat + ".bin","ab")
            print "\nDatei geschlossen"
            print "===>   Neue Datei geöffnet: ", AktDat, "\n"
            x= 0
            istTag= Lzeit[2]
        else:
            if Lzeit[4]% 5 == 0:#		Alle 5 Min Daten auf Disk schreiben
                if Flush:
                    OnS.flush()
                    Flush= False
                    print"Flush"
            elif Flush== False:
                Flush= True
                print"True"

    except (KeyboardInterrupt):
        spi.close()
        #On1.close()
        OnS.close()
        run= False

###############   Hoehe ueber NN berechnen ########
Pnn=1033.0 #   Luftdruck (NN) Kaufbeuren
#Pist=messwerte[-1][2]
Pist=druck
hoehe=44330*(1-(float(Pist)/float(Pnn))**(1/5255.0))
print"\nDruck auf NN=    %6.1f hPa" % Pnn
print"Druck akt. Wert= %6.1f hPa" % Pist
print"Hoehe ueber NN= %7.2f" % (hoehe*1000.0)

print"\nENDE"
