# -*- coding: utf-8 -*-
#   ++++++++   Empfang per TTY, dekodieren und abspeichern der EDL-SML Daten

from time import sleep, time, localtime, mktime, asctime
from RPi.GPIO import RPI_INFO
import serial, sys



def opendat(EDLpfad):
    zeitS= localtime()
    datzeit= "%04i%02i%02i" % (zeitS[:3])
        
    DatName= EDLpfad + datzeit+ ".edl"
    print"Datei:", DatName, "wird angelegt"

    datei= open(DatName,"a")
    if datei.tell()== 0:
        datei.write("Struktur: TID, T, BS, LS, T1B, T1L, T2B, T2L, WIst\n")
        datei.write("Feldname: TransferID, Time, BezugSumme, LieferSumme, Tarif1Bezug, Tarif1Liefer, Tarif2Bezug, Tarif2Liefer, WirkleistungIst\n")
    return datei


#   ==================   Decodierung start   ===============
def SMLcode(daten):
    Code= (daten & 0xf0) >> 4
    Anz= daten & 0x0f
    return  Code, Anz


def SMLread(lang, SMLblock):
    global SMLpos
    eindat= SMLblock[SMLpos: SMLpos +lang]
    SMLpos += lang
    return eindat


def anzeige(daten):
    for x in daten:
        print hex(ord(x)),


def sekAnz(liste):
    erg=0
    for x in liste:
        erg *= 256
        erg += ord(x)
    return erg
 

def stromumrechnung(daten):
    if ord(daten[0])== 0x52:

        multi= ord(daten[1])
        if multi> 128:
            multi= 1/10.0**(0x100-multi)
    else:
        multi=1

    daten= daten[3:]
    wert=0
    vz= (ord(daten[0]) & 0x80 ) >> 7
    byteAnz= len(daten)
    for x in daten:
        wert <<= 8
        wert|= ord(x)
    if vz:
        wert= -1*((1 << (byteAnz*8))- wert)
    return wert* multi


def SMLstart(SMLblock):
    ret=[]
    eindat0= ord(SMLread(1, SMLblock))
    Code, Anz= SMLcode(eindat0)
    if Code== 7:
        einlang= ord(SMLread(1, SMLblock))
        eindat= SMLread(einlang-1, SMLblock)
        einS=""
        for x in eindat:
            einS += "%02x" %(ord(x))
        ret.append(einS+"/")#           TID/ Transfer ID

        if test:
            print hex(eindat0)," - SML Message (Start) mit" , Anz, "Einträgen"
            print"\tDatenlänge incl.:", einlang
            print "\tTransaction_ID/ Daten:\t",
            anzeige(eindat); print

        eindat1= ord(SMLread(1, SMLblock))
        Code, Anz= SMLcode(eindat1)
        if Code== 6:
            eindat= SMLread(Anz-1, SMLblock)
            if test:
                print hex(eindat1), "--> GroupNo, mit ", Anz, "Bytes"
                print"\tGruppen-Nr.:",
                anzeige(eindat)
                print

        eindat1= ord(SMLread(1, SMLblock))
        Code, Anz= SMLcode(eindat1)
        if Code== 6:
            eindat= SMLread(Anz-1, SMLblock)
            if test:
                print hex(eindat1), "--> AbortOnError"
                print"\tHandling Übertragungsfehler.:",
                anzeige (eindat)
    return ret


def SMLbody0201(SMLblock):
    global SMLpos
    eindat= ord(SMLread(1, SMLblock))
    Code, Anz= SMLcode(eindat)
    if Code== 7:
        if test:
            print "\n\t", hex(eindat),"Eintrag mit", Anz, "Einträgen"
        eindat1= ord(SMLread(1, SMLblock))
        Code, Anz= SMLcode(eindat1)


def SMLbody0701(SMLblock):
    global SMLpos
    ret=[]
    eindat= ord(SMLread(1, SMLblock))
    Code, Anz= SMLcode(eindat)
    if Code == 7:#      (77)           (2.5)
        if test:
            print"-->", hex(eindat), "- Nachricht mit", Anz,"Einträgen"
        eindat= ord(SMLread(1, SMLblock))
        if test:
            print"\tClientID:", eindat#             Block 1 (2.5 1)

        einlang= ord(SMLread(1, SMLblock))
        eindat= SMLread(einlang-1, SMLblock)
        if test:
            print"\tDatenlänge:", einlang
            print"\t\tserverID:",#                  Block 2 (2.5 2)
            anzeige(eindat)

        einlang= ord(SMLread(1, SMLblock))
        eindat= SMLread(einlang-1, SMLblock)
        if test:
            print"\n\tDatenlänge:", hex(einlang)
            print"\tListName???:",#                 Block 3 (2.5 3)
            anzeige(eindat)

        eindat1= ord(SMLread(1, SMLblock))
        Code1, Anz1= SMLcode(eindat1)
        if Code1== 7:#             (72)             Block 4 (2.5 4)
            eindat= ord(SMLread(1, SMLblock))
            Code, Anz= SMLcode(eindat)
            if test:
                print "\n",hex(eindat1),"Nachricht mit", Anz1, "Einträgen"
                print"\tTyp: sekIndex",
            if Code== 6:#       (62)
                eindat= ord(SMLread(Anz-1, SMLblock))
                if test:
                    print hex(eindat)#      sek Index

            eindat1= ord(SMLread(1, SMLblock))
            Code, Anz= SMLcode(eindat1)
            if Code== 6:#       (65)          Zeitindex (sek)
                eindat= SMLread(Anz-1, SMLblock)
                istsek= sekAnz(eindat)
                Stime= mktime([2016,8,19,7,23,0,0,0,0])#    Startzeit Zähler
                Atime= asctime(localtime(Stime+ istsek))
                zeitS=str(Stime+ istsek)

                if test:
                    print "\t",hex(eindat1),"Eintrag mit Länge", Anz
                    print"\t\tSekunden Index",
                    anzeige(eindat)
                    print "\n\t\tSekunden seit Einschalten:", istsek
                    print"\t\tZeitstempel:", Atime
                ret.append((zeitS+"/"))#        T/ Timestamp

        eindat1= ord(SMLread(1, SMLblock))#                       Block 5 (Value-List)
        Code, Anz1= SMLcode(eindat1)
        if Code== 7:#                   (7a)
            if test:
                print"\n-->", hex(eindat1), "Nachricht mit", Anz1, "Einträgen"

            for schleife in range(0,Anz1):
                if test:
                    print "schleife",schleife, "von", Anz1

                eindat2= ord(SMLread(1, SMLblock))
                Code2, Anz2= SMLcode(eindat2)

                if Code2== 7:
                    einlang= ord(SMLread(1, SMLblock))
                    eindat= SMLread(einlang-1, SMLblock)
                    if test:
                        print "    ",hex(eindat2), "\t%02i. Nachricht mit %i" %((schleife+1),Anz2), "Einträgen" 
                        print"\tDatenlänge:", einlang-1
                        print"\t\tORBIS-Kennung:",
                        anzeige(eindat)

                    if eindat==chr(0x81)+ chr(0x81) + chr(0xc7) + chr(0x82)+ chr(0x03)+ chr(0xff):
                        eindat= SMLread(9, SMLblock)
                        if test:
                            print "\n\t\t129-129:199.130.3*255/ Hersteller-ID"
                            print"\tCodestring:[",
                            anzeige(eindat),
                            print"]"
                            print"\tstatus:",hex(ord(eindat[0]))
                            print"\tvalTime:",hex(ord(eindat[1]))
                            print"\tunit:",hex(ord(eindat[2]))
                            print"\tscaler:",hex(ord(eindat[3]))
                            print"\tHersteller:", eindat[4:8]
                            print"\tvalueSignature:",hex(ord(eindat[8]))


                    elif eindat==chr(0x1)+ chr(0x0) + chr(0x0) + chr(0x0)+ chr(0x09)+ chr(0xff):
                        if test:
                            print"\n\t\t / / Server ID (Seriennummer?)"
                        eindat= ord(SMLread(1, SMLblock))
                        while eindat==1:
                            if test:
                                print "\tEintrag leer:", hex(eindat)
                            eindat= ord(SMLread(1, SMLblock))

                        einlang= eindat
                        eindat= SMLread(einlang-1, SMLblock)
                        if test:
                            print "\tDatenlänge", einlang-1,
                            print"\n\t\tdaten ???",
                            anzeige(eindat)
                            print

                        eindat= ord(SMLread(1, SMLblock))
                        if test:
                            print "\tDaten:", hex(eindat)
                            

                    elif eindat==chr(0x1)+ chr(0x0) + chr(0x1) + chr(0x8)+ chr(0x00)+ chr(0xff):
                        if test:
                            print "\n\t\t1-0:1.8.0*255 = Wirkenergie Total Bezug"

                        eindat= SMLread(16, SMLblock)
                        erg= stromumrechnung(eindat[7:15])
                        if test:
                            print"\t",
                            anzeige(eindat)
                            print "\n\tERGEBNIS:", erg
                        ret.append((str(round(erg,2))+"/"))#    BS/ Bezug Summe


                    elif eindat==chr(0x1)+ chr(0x0) + chr(0x2) + chr(0x8)+ chr(0x00)+ chr(0xff):
                        if test:
                            print "\n\t\t1-0:2.8.0*255 = Wirkenergie Total Lieferung"
                        eindat= SMLread(16, SMLblock)
                        erg= stromumrechnung(eindat[7:15])
                        if test:
                            print"\t",
                            anzeige(eindat)
                            print"\n\tErgebnis:", erg
                        ret.append((str(round(erg,2))+"/"))#    LS/ Liefer summe


                    elif eindat==chr(0x1)+ chr(0x0) + chr(0x1) + chr(0x8)+ chr(0x01)+ chr(0xff):
                        if test:
                            print "\n\t\t1-0:1.8.1*255 = Wirkenergie Tarif 1 Bezug"

                        eindat= SMLread(13, SMLblock)
                        erg= stromumrechnung(eindat[4:12])
                        if test:
                            print"\t",
                            anzeige(eindat)
                            print"\n\tErgebnis:", erg
                        ret.append((str(round(erg,2))+"/"))#    T1B/ Tarif 1 Bezug


                    elif eindat==chr(0x1)+ chr(0x0) + chr(0x2) + chr(0x8)+ chr(0x01)+ chr(0xff):
                        if test:
                            print "\n\t\t1-0:2.8.1*255 = Wirkenergie Tarif 1 Lieferung"

                        eindat= SMLread(13, SMLblock)
                        erg= stromumrechnung(eindat[4:12])
                        if test:
                            print"\t",
                            anzeige(eindat)
                            print"\n\tErgebnis:", erg
                        ret.append((str(round(erg,2))+"/"))#    T1L/ Tarif 1 Liefer


                    elif eindat==chr(0x1)+ chr(0x0) + chr(0x1) + chr(0x8)+ chr(0x02)+ chr(0xff):
                        if test:
                            print "\n\t\t1-0:1.8.2*255 = Wirkenergie Tarif 2 Bezug"

                        eindat= SMLread(13, SMLblock)
                        erg= stromumrechnung(eindat[4:12])
                        if test:
                            anzeige(eindat)
                            print"\n\tErgebnis:", erg
                        ret.append((str(round(erg,2))+"/"))#    T2B/ Tarif 2 Bezug


                    elif eindat==chr(0x1)+ chr(0x0) + chr(0x2) + chr(0x8)+ chr(0x02)+ chr(0xff):
                        if test:
                            print "\n\t\t1-0:2.8.2*255 = Wirkenergie Tarif 2 Lieferung"
                        eindat= SMLread(13, SMLblock)
                        erg= stromumrechnung(eindat[4:12])
                        if test:
                            print"\t",
                            anzeige(eindat)
                            print"\n\tErgebnis:", erg
                        ret.append((str(round(erg,2))+"/"))#    T2L/ Tarif 2 Liefer


                    elif eindat==chr(0x1)+ chr(0x0) + chr(0x10) + chr(0x7)+ chr(0x0)+ chr(0xff):
                        if test:
                            print "\n\t\t1-0:16.7.0*255 = Momentane Wirkleistung"

                        eindat= SMLread(12, SMLblock)
                        erg= stromumrechnung(eindat[4:11])
                        if test:
                            print"\t",
                            anzeige(eindat)
                            if erg<0:
                                print"\n\tLieferung -",
                            else:
                                print "\n\tBezug -",
                            print abs(erg), "W/h"
#                        ret.append((str(round(erg,2))+"/"))#    WIst/ Wirkleistung Ist
                        ret.append((str(round(erg,2))))#    WIst/ Wirkleistung Ist


                    elif eindat==chr(0x81)+ chr(0x81) + chr(0xc7) + chr(0x82)+ chr(0x5)+ chr(0xff):
                        if test:
                            print "\n\t\t129-129:199.130.5*255 = Hersteller-Identifikation (Public Key)"

                        eindat= ord(SMLread(1, SMLblock))
                        while eindat==0x01:#                        Block 2
                            if test:
                                print"\tNicht gesetzt:", eindat
                            eindat= ord(SMLread(1, SMLblock))
                        
                        Code, Anz= SMLcode(eindat)#                 Block 3
                        if Code== 7:
                            if test:
                                print "\n\t",hex(eindat),"Eintrag mit", Anz, "Blöcken"
                            eindat= ord(SMLread(1, SMLblock))
                            Code2, Anz2= SMLcode(eindat)
                            if Code2== 6:
                                
                                einlang= ord(SMLread(1, SMLblock))
                                if test:
                                    print "\t",hex(eindat),"Eintrag mit", Anz2,"Byte"
                                    print "\t\t",hex(einlang),
                                    if einlang-1 <=0:
                                        print"Eintrag nicht gesetzt",

                                eindat1= ord(SMLread(1, SMLblock))
                                Code, Anz= SMLcode(eindat1)
                                if Code==6:#                    === Zeitstempel???
                                    eindat= SMLread(Anz-1, SMLblock)
                                    if test:
                                        print"\n\t", hex(eindat1), "Eintrag mit", Anz,"Byte (Zeitstempel ?)"
                                        print"\t\t",
                                        anzeige(eindat)
                                if test:
                                    print

                        eindat= ord(SMLread(1, SMLblock))#                    Block 4, 5
                        while eindat <=1:
                            if test:
                                print "\t",hex(eindat),"Eintrag nicht gesetze"
                            eindat= ord(SMLread(1, SMLblock))

                        Code, Anz= SMLcode(eindat)
                        if Code==8:#                                Block 6
                            eindat= ord(SMLread(1, SMLblock))
                            Code1, Anz1= SMLcode(eindat)
                            einlang= Anz << 4 | Anz1

                            if test:
                                print "\t",hex(eindat)," Eintrag mit", einlang- 2, "Bytes"
                            eindat= SMLread(einlang-2, SMLblock)
                            if test:
                                print "\tLang:",einlang-2
                                print"\t\tDaten",
                                anzeige(eindat)

                            eindat= ord(SMLread(1, SMLblock))#                    Block 7
                            if eindat <=1:
                                if test:
                                    print "\n\t",hex(eindat),"Eintrag nicht gesetzt"

        for rest in xrange(0,2):
            eindat= ord(SMLread(1, SMLblock))#        (77.6/ 77.7)
            if eindat== 1:
                if test:
                    print "\tEintrag nicht gesetzt", hex(eindat)

    return ret


def SMLbody0101(SMLblock):
    global test, start, SMLpos
    ret=[]
    eindat1= ord(SMLread(1, SMLblock))
    Code, Anz= SMLcode(eindat1)
    if Code== 7:
        eindat= SMLread(2, SMLblock)
        if test:
            print"SML Body 1_1"
            print "\n",hex(eindat1), "--> Nachricht mit", Anz, "Einträgen"
            print"\tCodepage:", ord(eindat[0])
            print"\tClientID:", ord(eindat[1])

        einlang= ord(SMLread(1, SMLblock))
        eindat= SMLread(einlang-1, SMLblock)
        if test:
            print"\tDatenlänge:", einlang
            print"\treqFileID:",
            anzeige(eindat)
        ret.append(("Grunddaten",["reqFileID",eindat]))

        einlang= ord(SMLread(1, SMLblock))
        eindat= SMLread(einlang-1, SMLblock)
        if test:
            print"\n\tDatenlänge:", einlang
            print"\tserverID:",
            anzeige(eindat)
            print
        ret.append(("Grunddaten",["serverID",eindat]))

        eindat= SMLread(2, SMLblock)
        if test:
#            print"\tuserName:",hex(ord(eindat[0]))
#            print"\tpassword:",hex(ord(eindat[1]))
            print"\trefTime:",hex(ord(eindat[0]))
            print"\tsmlVersion:",hex(ord(eindat[1]))




def SMLbody(SMLblock):
    eindat= ord(SMLread(1, SMLblock))
    Code, Anz= SMLcode(eindat)
    if Code== 7:
        if test:
            print "\n",hex(eindat), "--> (Body) Liste mit", Anz, "Einträgen"
        eindat1= ord(SMLread(1, SMLblock))
        Code, Anz= SMLcode(eindat1)
        if Code== 6:
            eindat= SMLread(Anz-1, SMLblock)
            if test:
                print"-->", hex(eindat1),"- Nachricht mit", Anz-1,"Bytes"
                print"\t-->Nachricht ",
                print hex(ord(eindat[0])), hex(ord(eindat[1])),

            if eindat== chr(1) + chr(1):
                if test:
                    print "SML_PublicOpen.Res. 1 1"
                ret_body= SMLbody0101(SMLblock)
                if test:
                    print "SML_PublicOpenRes. fertig"
                    eintast= raw_input("weiter body_1_1")

            elif eindat== chr(7) + chr(1):
                if test:
                    print "SML_GetList.Res. 7 1"
                ret_body= SMLbody0701(SMLblock)
                if test:
                    print "SML_GetList.Res. fertig"
                    eintast= raw_input("weiter body_7_1")

            elif eindat== chr(2) + chr(1):
                if test:
                    print "SML_PublicClose.Res. 2 1"
                ret_body= SMLbody0201(SMLblock)
                if test:
                    print "SML_PublicClose.Res. fertig"
                    eintast= raw_input("weiter body_2_1")

            else:
                #if test:
                print "\n\t===> unbekannter Code [Z: 483]\n"
                ret_body="[Z: 484] Unbekannter Nachrichten-Code: %02x %02x" % (ord(eindat[0]), ord(eindat[1]))
        else:
            ret_body="Unbekannter Fehler aufgetreten"
    return ret_body


def SMLende(SMLblock):
    global SMLpos
    eindat1= ord(SMLread(1, SMLblock))
    Code, Anz= SMLcode(eindat1)
    if Code== 6:
        eindat= SMLread(Anz-1, SMLblock)
        if test:
            print hex(eindat1),"Eintrag mit ",Anz-1, "Bytes"
            print"\tCRC: ",
            anzeige(eindat)

    eindat= ord(SMLread(1, SMLblock))
    Code, Anz= SMLcode(eindat)
    if Code== 0:
        if Anz==0:
            if test:
                print"\n\t", hex(eindat),"===== Nachricht-ENDE =====\n"



def SMLdecode(SMLblock):
    global test, SMLpos

    if test:
        print"Message-Beginn"

    #**********************************   Teil 1   ******************************
    if test:
        print"Dateipos.:", SMLpos

    start_ret1= SMLstart(SMLblock)
    body_ret1= SMLbody(SMLblock)
    ende_ret1= SMLende(SMLblock)

    #**********************************   Teil 2   ******************************
    if test:
        print"\n\n Teil 2\n"

    start_ret2= SMLstart(SMLblock)
    body_ret2= SMLbody(SMLblock)
    ende_ret2= SMLende(SMLblock)

#   **********************************   Teil 3   ***********************
    if test:
        print"\n\n Teil 3\n"

    start_ret3= SMLstart(SMLblock)
    body_ret3= SMLbody(SMLblock)
    ende_ret3= SMLende(SMLblock)

#    print"start2ret", start_ret2
#    print start_ret2[0][0]
#    for x in start_ret2[0][1]:
#        print hex(ord(x))

#    print"body2ret", body_ret2
#    for x in body_ret2:
#        print x[0],x[1]
#    print"typ:", type(start_ret2)
    ret=tuple(start_ret2)
    ret+= tuple(body_ret2)
#    for x in ret:
#        print "ret:", x
    
#    return start_ret2, body_ret2
    return ret


def SMLstatistik(StromErg):
#   ==================   Statistik anzeigen   ===================
    while True:
        print"\n\nStatistik-Auswahl"
        print"1 = Aktuelle (letzte) Werte"
        print"2 = Aktuelle (erste) Werte"
        print"3 = Werteliste Istleistung"
        print"0 = E N D E"
        eintast= raw_input("\nAuswahl: ")
        if eintast=="1":
            SMLWerte(StromErg,"neu")

        elif eintast=="2":
            SMLWerte(StromErg,"alt")

        elif eintast=="3":
            print "Startwert, Stopwert durch Komme getrennt eingeben\n(0 für Anfang, -1 für Ende)"
            eintast= raw_input("Start, Stop: ")
            werte= eintast.split(",")
            istListe(StromErg, werte)

        elif eintast=="0":
            break
        else:
            print"Nur Eingaben 0, 1, 2, 3 zulässig."
            print"Bitte wiederholen"


def Dekodierung(SMLblock):
    global SMLpos
#   ========================   Dekodierung start   ======================

    SMLpos=0
    ret_decode= SMLdecode(SMLblock)
        
#============================
    if test:
        print"Dateipos:", SMLpos
    modpos= divmod(SMLpos, 4)
    modanz= 4- modpos[1]
    eindat= SMLread(modanz, SMLblock)
    if test:
        print"berechnete Füllbytes:", modanz
        print "Vorhandene Füllbytes:",
        anzeige(eindat)
        print"Dateipos:", SMLpos

    while eindat != chr(0x1b):
        eindat= SMLread(1, SMLblock)
    if test:
        print"Endesequenz 1b 1b 1b 1b gefunden"
    suche= chr(0x1b)* 4
    find= True
    while eindat != suche:
        eindat += SMLread(1, SMLblock)
        if len(eindat)> 4:
            if test:
                print" Escapefolge 1B 1B 1B 1B nicht gefunden"
            find= False
            break
        
    if find:
        eindat= ord(SMLread(1, SMLblock))
        if eindat== 0x1a:
            if test:
                print"Endekennung gefunden", hex(eindat)

    eindat= ord(SMLread(1, SMLblock))
    eindat= SMLread(2, SMLblock)
    if test:
        print"Angekündigte Füllbytes:", eindat
        print"CRC_16 Prüfsumme gesamte Nachricht:",
        anzeige(eindat)
        print"\n\t============   Komplette Bearbeitung beendet  ========="
            
    if test:
        print"""//////////////////////////  E N D E   \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\"""

    if test:
        print "\nGesamtlänge ist:", len(SMLblock)
        print"Istposition:", SMLpos

    if test:
        print "Gesamtlänge ist:", len(SMLblock)

    if test==3:#            Nicht ausführen, auch wenn test gesetzt ist
        try:
            eintast= raw_input("weiter (Neue Nachricht)")
        except KeyboardInterrupt:
            print "Programmabbruch"
            stop#   break
    return ret_decode

#   ==================   Dekodierung Ende   ================


def ttyread():
    global port, tty
    Tread=time()
    while not port.inWaiting():
        sleep(.1)
        if time()-Tread > 10:
            print" Mindestens 10 Sekunden keine TTY-Daten erhalten. Abbruch!"
            return 1
    lang= port.inWaiting()
    tty += port.read(lang)
    return 0


def anzeigen(blockneu):
    Dsammler=""
    for x in blockneu:
        Dsammler += hex(ord(x))+","
    print Dsammler



#   ========================   Hauptprogramm   ======================

print "Neue Daten vom 'Zähler-Rechner' übertragen in Shell mit:"
print "sudo scp pi@raspi2b-zaehler:/home/pi/Python/test/roh_daten_20161020.txt /home/pi/Python/test\n"

#StromErg={"Grunddaten":[],"Timestamp":[],"BezugSum":[],"LieferSum":[],"WirkIst":[],
#          "Tarif1Bezug":[], "Tarif1Liefer":[], "Tarif2Bezug":[],
#          "Tarif2Liefer":[],"TransactionID":[]}

#test= False
test= True
SMLpos=0
zaehler=0


erg= RPI_INFO
RPIversion= int(RPI_INFO["P1_REVISION"])#       RPI Version herausfinden
RPItype= RPI_INFO["TYPE"]
print"Raspi Version", RPIversion, "erkannt"
print"Raspi Type", RPItype
Rtyp= RPItype.split(" ")
if Rtyp[0]=="Pi":
    print "TypeNeu:",Rtyp[1]
    RPIversion = int(Rtyp[1])

print"RPI-Version:", RPIversion,

if RPIversion== 2:
    tty="/dev/ttyAMA0"
    print"AMA0"
else:
    tty="/dev/ttyS0"
    print"tty"
    
port=serial.Serial(tty, 9600, timeout=0)#           TTY-Port öffnen
print "Port:", port, "TTY:",tty

port.flushInput()#                                  TTY Eingabepuffer leeren
port.flushOutput()#                                 TTY Ausgabepuffer leeren

#   ==========================   Ausgabe-Datei anlegen   ===============
EDLpfad= None
try:
    einfile= open("./configSERVER.txt","r")
except:
    print"\nProgrammabbruch:\nDatei 'configSERVER.txt' kann nicht gefunden werden"
    quit(2)
    
for eindat in einfile:
    einzeile= eindat.strip().split(":")
    print "zeile", einzeile
    if einzeile[0]== "EDLdaten":
        EDLpfad= einzeile[1]
einfile.close()
#if EDLpfad ==None:
#    print"""\nIn der Datei 'configSERVER.txt' ist der Speicherpfad für die Dateien
#nicht gesetzt. Der Parameter 'EDLdaten' muß dort gesetzt sein.
#Programmabbruch!"""
#    quit(1)

try:
    datei= opendat(EDLpfad)
except:
    print"\nProgrammabbruch:\nDatenpfad bei <" + EDLpfad + "> kann nicht gefunden werden"
    quit(1)
#   ====================================================================

alttag= localtime()[2]
such_ESC= chr(0x1b)*4
such_01= chr(0x01)*4
such_DE= chr(0x1a)

tty=""
trymax= 10#     Maximale Versuchsanzahl, Daten von der TTY-Schnittstelle zu erhalten
count= trymax
while len(tty) < 750:
    ttyret= ttyread()
    print "TTYret:",ttyret
    if ttyret != 0: count -= 1
    if count <= 0:
        print"\nProgrammabbruch!\nFür mindestens %d mal 10 Sekunden keine TTY-Daten erhalten." % (trymax)
        quit(3)

print"tty länge >= 750 erreicht"

Bstart= tty.find(such_ESC +such_01)+8#     1. ESC-Start Sequenz suchen
tty= tty[Bstart-8:]#                      Eingabesammler Vorne kürzen
Bstart=0
Bneu= True

while True:

    Bneu= -1
    while Bneu < 0:
        Bneu= tty.find(such_ESC +such_01, 1)#         ESC-Start Sequenz suchen (neuer Block)
        if test:
            print" Bneu Sequenz Start", Bneu, type(Bneu)
        if Bneu >= 0:
            Bneu += 8
            Tbneu= time
        else:
            ret_read= ttyread()
            if ret_read:
                sleep(1)
    if test:
        print" Bneu Sequenz Ende", Bneu, type(Bneu)


    Bende=-1
    Bende= tty.find(such_ESC+ such_DE, 1)#    ESC-Ende Sequenz suchen
    if test:
        print"Blockendesequenz ", Bende

    
        print"Start", Bstart#, "dauer:", Tende1-Tstart1
        print"Blockende", Bende#, "dauer:", Tende2-Tstart2
        print "BlockNeu", Bneu#, "dauer:", Tende3-Tstart3
        print"\nLänge Eingabepuffer:", len(tty)


    blockneu= tty[8:Bneu-7]#                             Auswerteblock bereitstellen
    tty= tty[Bneu-8:]
    if Bende  < 0:
        print "=====   Blockende Sequenz nicht gefunden. Block wird verworfen!   ====="
        anzeigen(blockneu)
        print "======================   Verworfener Block Ende   ====================="
    else:
        zaehler += 1
        sys.stdout.write(str(zaehler)+" "),
        sys.stdout.flush()
        if zaehler > 10000:
            zaehler=0
            
        ret_dec= Dekodierung(blockneu)
        for x in ret_dec:
            if type(x)==str:
                datei.write(x)
            else:
                datei.write(str(x))
        datei.write("/")
        datei.write("\n")

        neutag= localtime()[2]#         Datum auf 'neuen Tag' prüfen
        if neutag != alttag:
            datei.flush()
            datei.close()#               Alte Datei schließen
            datei= opendat()#               und neue Datei anlegen
            print alttag, neutag
            alttag= neutag#             Neuen Tag setzen
