#!/usr/bin/env python
# -*- coding: utf-8 -*-


import MOD_import_20170709_2000 as IMP

class LCD():#           ===== Fake LCD-Klasse  =====
    def __init__(self):
        print"LCD __init__ wird aufgerufen"
        try:
            einfile= open("./LCD240config.txt","r")
        except:
            print"Datei 'LCD240config.txt' wurde nicht gefunden. Abbruch!"
            quit(1)

        self.IP_addr=None#        IP-Adresse aus config-Datei extrahieren
        for eindat in einfile:
            zeile= eindat.split(":")
            if zeile[0]=="IP_addr".upper():
                self.IP_addr= zeile[1]          
                break
        einfile.close()
        print"IP:", self.IP_addr
        

class HM_status:
    def __init__(self, IMP):
        self.test= False
        self.SerPo= 8181
        self.HM_script ={"Servicemeldungen":"""
var suchDev;
string indexSM;
var Smess;
string finde;
var stelle;
var stelle2;
var geraet=dom.GetObject(28);!    ===  Alle System ServiceMeldungen

foreach(indexSM, geraet.EnumUsedIDs())
{
  Smess=dom.GetObject(indexSM);
  if(Smess.State())
  {!   ===  Wenn Status aktiv dann...
    finde="BidCos-RF." # Smess.Name().Substr(3);
    suchDev=dom.GetObject(finde);
    Write(Smess.Timestamp().Format("%Y-%m-%d %H:%M")#";");
    var istDev=dom.GetObject(suchDev.Device());
    stelle=istDev.Name().Find(":");
    stelle2=Smess.Name().Find(".");
    Write(istDev.Name().Substr(0,stelle) # ";");
    WriteLine(Smess.Name().Substr(stelle2+1));
  }
}
""",
    "Root_1000":"""
integer start = 0;
integer ende =  start + 1000;
var geraet;

while(start  <=  ende)
{
  geraet=dom.GetObject(start);
  if (geraet)
  {
    WriteLine(geraet.ID() # "\t" # geraet.Name());
  }
  start = start +1;
}
""",
    "Root_Channels":"""
var dev; ! ================   Alle Root channels   ===========
var chan;
var chans;
string idx;

dev= dom.GetObject("Root channels");
Write("Dev: " # dev);
if (dev)
{
  WriteLine(" ==> gefunden!");
  chans= dev.EnumUsedNames();
  foreach(idx, chans)
  {
    WriteLine(idx);
  }
}
""",
    "Stellantrieb_DP":"""
!   Datenpunkt-Status von Stellantrieben 
object dev;
object einzeln;
string schleife;
string geraet;
var daten;
string auswahl;

string zustand="VALVE_STATE,BATTERY_STATE,ACTUAL_TEMPERATURE,SET_TEMPERATURE,CONTROL_MODE";
integer auswahlNR= 2;
auswahl= zustand.StrValueByIndex(",", auswahlNR);

dev= dom.GetObject(151); !   ********    Gewerke
WriteLine(dev.Name() # ": " # dev.EnumUsedNames());

foreach (schleife, dev.EnumUsedNames())
{
  if (schleife.Find("Stellantr") > -1)
  {
    WriteLine(auswahl # "\t=>\t" # schleife);
    var erg= dom.GetObject(schleife);
    foreach(geraet, erg.EnumUsedNames())
    {
      Write(geraet);
      einzeln= dom.GetObject(geraet);
      daten= einzeln.DPByHssDP(auswahl);
      WriteLine("\tWert: \t"# daten.Value());
    }
  }
}
""",
    "Thermostat_DP":"""
!   Datenpunkt-Status von Thermostaten 
object dev;
object einzeln;
string schleife;
string geraet;
var daten;
string auswahl;

string zustand="VALVE_STATE,BATTERY_STATE,ACTUAL_TEMPERATURE,SET_TEMPERATURE,CONTROL_MODE";
integer auswahlNR= 2;
auswahl= zustand.StrValueByIndex(",", auswahlNR);

dev= dom.GetObject(151); !   ********    Gewerke
WriteLine(dev.Name() # ": " # dev.EnumUsedNames());

foreach (schleife, dev.EnumUsedNames())
{
  if (schleife.Find("Thermos") > -1)
  {
    WriteLine(auswahl # "\t=>\t" # schleife);
    var erg= dom.GetObject(schleife);
    foreach(geraet, erg.EnumUsedNames())
    {
      Write(geraet);
      einzeln= dom.GetObject(geraet);
      daten= einzeln.DPByHssDP(auswahl);
      WriteLine("\tWert: \t"# daten.Value());
    }
  }
}
""",
    "Root_Devices":"""
var ger;
var liste;
string index;

ger= dom.GetObject("Root devices");
if (ger)
{
    WriteLine("Ger-Name: " + ger.Name());
    WriteLine("Count:  " # ger.Count());

    liste= ger.EnumUsedNames();
    foreach(index, liste)
    {
      WriteLine("Index:   " # index);
    }
}"""}



    def Script_Start(self, HM_script):
        ScriptLang=len(HM_script)
        self.s = IMP.SOC.socket(IMP.SOC.AF_INET, IMP.SOC.SOCK_STREAM)
        try:
            self.s.connect((str(LCD1.IP_addr), self.SerPo))
            if self.test:
                print "Gesendet:" ,str(ScriptLang), "Bytes"

            self.s.send("POST /Test.exe HTTP/1.1\r\n")
            self.s.send("Host: "+ LCD1.IP_addr.strip()+ ":"+ str(self.SerPo)+"\r\n")###    NEU
            self.s.send("Content-Type: application/x-www-form-urlencoded\r\n")
            self.s.send("Content-Length: " + str(ScriptLang) + "\r\n")
            self.s.send("Connection: close\r\n\r\n")
            testS = self.s.send(HM_script)

    #   ============================   neu Start   ========================
            print"> Gesendet: %s (Bytes)"% testS
            res1 = self.s.recv(512)#     *** response auf Anfrage

            if self.test:
                print "### Empfangen ###"
            resP= res1.split("\r\n\r\n")#       *** Datenanfang finden
            resp0 = resP[0].splitlines()
            foundDL = False
            findOK = False
            for x in resp0:
                if x.find ("OK") >= 0:#         ***  OK gefunden ?
                    findOK = True
                elif findOK and x.find("Length") >= 0:#      ***  Datenlänge finden
                    resp0P = x.split(": ")
                    Dlang = int(resp0P[1])
                    res2 = resP[1]
                    foundDL = True
                    break

            if findOK:
                if foundDL:#                      ***  Datenlänge gefunden
                    resP = resP0 = resp0P = None
                    print "< Empfangen, Länge (soll): ", Dlang, "\nempfangsdatenlänge:"
                    while len(res2) < Dlang:#   ***  Alle Daten aus Puffer lesen
                        print len(res2),
                        res2 +=  self.s.recv(8192)
                    print len(res2),"\n"

                    M_ret_part = res2.split("<xml>")
                    M_ret_line = M_ret_part[0].splitlines()
                    M_return = ("OK", self.s, M_ret_line)
                    return(M_return)

                else:#                              ***  Datenlänge nicht vorhanden
                    M_return= ("Fehler", "HMsend_002","Keine Datenlänge vorhanden")
            else:#                                      ***  OK NICHT vorhanden
                M_return = ("Fehler", "HMsend_001","Kein OK in Antwort vorhanden")

        except (IMP.SOC.error):
            print"Keine Verbindung möglich!"
            M_return = ("Fehler","HMsend_000","Keine Verbindung zum Ziel")
            return M_return



def sozei(werte):
    sammler=""
    for x in werte:
        such= ord(x)
        if such > 127:
###            print "Sonderzeichen 2. Wert:", such
            if such== 252:#           Sonderzeichen "ü" ersetzen
                sammler += "ü"
            elif such== 228:#           Sonderzeichen "ä" ersetzen
                sammler += "ä"
            elif such== 999:#           Sonderzeichen "ö" ersetzen
                sammler += "ö"
            elif such== 58:#           Sonderzeichen "ß" ersetzen
                sammler += "ß"
        else:
            sammler += x
    return sammler


####################   Hauptprogramm   #####################

#       ***  Klassen definieren   ***
IMP=IMP.Import()
LCD1= LCD()
HMS1= HM_status(IMP)
                         
liste= HMS1.HM_script.keys()
liste.sort()

eintast=""
while eintast not in [range(0,len(liste)), "ende"]:
    print "\n\tHomeMatic-Anzeige"
    print"\t"+ "-" * 25
    for x in range(0,len(liste)):
        print "\t%2i  |   %s" % (x, liste[x])

    eintast= raw_input("\n\tAuswahl: ")
    if eintast.isdigit():
        eintast= int(eintast)

    if eintast in range(0, len(liste)):
        erg= HMS1.Script_Start(HMS1.HM_script[liste[eintast]])

        if erg[0] == "OK":
            if liste[eintast]== "Servicemeldungen":
                print "Anzahl Servicemeldungen:", len(erg[2])
                print"-" * 60
                for x in erg[2]:
                    zeile= tuple(x.split(";"))
                    print("%17s  |  %-26s |  %s") % (zeile)
                   
            elif liste[eintast]== "Root_1000":
                print "Anzahl Root_1000 Einträge:", len(erg[2])
                print"-" * 60
                for x in erg[2]:
                    zeile= list(x.split("\t"))
                    zeile[1]= sozei(zeile[1])
                    if len(zeile)> 1:
                        print("%4s  |  %s") % (tuple(zeile))
                    else:
                        print zeile

            else:
                print "Anzahl Einträge:", len(erg[2])
                print"-" * 60
                for x in erg[2]:
                    erg= sozei(x)
                    print erg

    elif eintast.upper()== "ende".upper():
        exit

print"ENDE"


try:
    del FIL1, HMS1, LCD1, IMP
except:
    print "Mindestens EIN Klassenverweis konnte nicht gelöscht werden"

quit()
