# -*- coding: utf-8 -*-

from thread import start_new_thread
from SimpleXMLRPCServer import SimpleXMLRPCServer
import socket
import time

import xmlrpclib
import HMmail_20181006_1943 as mail


config= {}
devices = {}
devnames= {}
devList = []
evtList = []
denList = []


#======================================================================


def mailtest(S_betreff, text):
    
    ret_conf= Email.config()

    if ret_conf[0]== 0:
        mailconf= ret_conf[1]
        Email.MailSend(S_betreff, text)
    else:
        print "Fehler beim Lesen der config-Datei aufgetreten\nProgrammabbruch"
        print ret_conf[1]



def denlist():
    zaehler= 1
    for dev in denList:
        for x in dev[2]:
            print x, ":",dev[2][x],
            if x== "ADDRESS":
                ger= dev[2][x]
                if ger.find(":") > 0:
                    ger= ger.split(":")[0]
                try:
                    print " = ",devices[ger][0]
                except:
                    print" = unbekannt (" + ger+")"
            else:
                print
            if divmod(zaehler, 20)[1]== 0:
                pause("devList weiter:")
            zaehler += 1
        print"-"* 50

def devlist():
    for x in devices:
        print x, devices[x]
        if divmod(zaehler,20)[1]== 0:
            pause("weiter")


def listdev1(devices):
    anz= 0
    for x in devices:
        if len(devices[x][3]) > 0:
            anz += 1
            print anz, devices[x][0]
            for dev in devices[x][3]:
                zeile= devices[x][3][dev]
                print "\t%04i.%02i.%02i / %02i:%02i:%02i" % (time.localtime(zeile[2])[:6]), dev, zeile[1]


def pause(text):
    raw_input(text)
    return

def schreibdaten():
    ausdat= open("./evtList.txt","w")
    ausdat.write(str(evtList))
    ausdat.close()
    print "evtList gespeichert"

    ausdat= open("./denList.txt","w")
    ausdat.write(str(denList))
    ausdat.close()
    print "denList gespeichert"

    ausdat= open("./devList.txt","w")
    ausdat.write(str(devList))
    ausdat.close()
    print "devList gespeichert"

    ausdat= open("./HMdevices.txt","w")
    ausdat.write(str(devices))
    ausdat.close()
    print "HMdevices gespeichert"


def XMLconfig():
    global config
    eindat= open("./config_XML_RPC.txt","r")
    for zeile in eindat:
        if zeile:
            if zeile[0] != "#":
                Tzeile= zeile.split(":")
                print "Tzeile:", Tzeile
                config[Tzeile[0]]= Tzeile[1].strip()



def Script_Start(IP,HM_script):

    ScriptLang=len(HM_script)
    s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    try:
        s.connect((str(IP), 8181))
#        print "Gesendet:" ,str(ScriptLang), "Bytes"

        s.send("POST /Test.exe HTTP/1.1\r\n")
        s.send("Content-Type: application/x-www-form-urlencoded\r\n")
        s.send("Content-Length: " + str(ScriptLang) + "\r\n")
        s.send("Connection: close\r\n\r\n")
        testS = s.send(HM_script)

        print"> Gesendet: %s (Bytes)"% testS
        res1 = s.recv(512)#     *** response auf Anfrage

#        print "### Empfangen ###"
        resP= res1.split("\r\n\r\n")#       *** Datenanfang finden
        resp0 = resP[0].splitlines()
        foundDL = False
        findOK = False
        for x in resp0:
            if x.find ("OK") >= 0:#         ***  OK gefunden ?
                findOK = True
            elif findOK and x.find("Length") >= 0:#      ***  Datenlänge finden
                resp0P = x.split(": ")
                Dlang = int(resp0P[1])
                res2 = resP[1]
                foundDL = True
                break

        if findOK:
            if foundDL:#                      ***  Datenlänge gefunden
                resP = resP0 = resp0P = None
                print "< Empfangen, Länge (soll): ", Dlang, "\nempfangsdatenlänge:"
                while len(res2) < Dlang:#   ***  Alle Daten aus Puffer lesen
                    print len(res2),
                    res2 +=  s.recv(8192)
                print len(res2),"\n"

                M_ret_part = res2.split("<xml>")
#                print "M_ret_part=",M_ret_part
                M_ret_line = M_ret_part[0].splitlines()
#                print "M_ret_line=", M_ret_line
                M_return = ("OK", s, M_ret_line)
                return(M_return)

            else:#                              ***  Datenlänge nicht vorhanden
                M_return= ("Fehler", "HMsend_002","Keine Datenlänge vorhanden")
        else:#                                      ***  OK NICHT vorhanden
            M_return = ("Fehler", "HMsend_001","Kein OK in Antwort vorhanden")



    except (socket.error):
        print"Keine Verbindung möglich!"
        M_return = ("Fehler","HMsend_000","Keine Verbindung zum Ziel")
        return M_return

script ="""
object obj;
object dev;
string Owert;

obj = dom.GetObject("Root devices");
foreach(Owert, obj.EnumUsedIDs())
{
    obj= dom.GetObject(Owert);
    Write(obj.ID() # "\t" # obj.TypeName() # "\t" # obj.Name() # "\t" # obj.Address());
    dev = dom.GetObject(obj.ID());
    WriteLine("\t" # obj.HssType() # "\t" # obj.Value());
}
"""


#==============================   Listings   ==================================

def events(evtList, devices):
    print
    print "Event-Einträge:\t", len(evtList)
    print
    for x in evtList:
        for y in range(1, len(x)):
            wert = x[y]
            if y == 1:
                dev = wert.split(":")[0]
                print devices[dev][0]+" : "+wert.split(":")[1]+ "\t",
            elif y == 0:
                zeit =time.localtime(wert),
                print time.strftime("%d.%m.%Y %H:%M",zeit[0]) + " >> ",
            else:
                print wert,
        print

    print
    print

def neuDevs(denList, devices):
    print "NewDev-Einträge:\t", len(denList)
    print

    for x in denList:
        if x[2]["PARENT"] == "":
            print x[2]["TYPE"],"Interface:", x[2]["INTERFACE"],
            wert = x[2]["ADDRESS"]
            try:
                Dname = devices[wert][0]
            except:
                Dname="--- unbekannt ---"
            print "SerNr:", wert, "Name: ", Dname
        else:
            print "\t",x[2]["PARENT"], x[2]["TYPE"], x[2]["INDEX"]



#   =========================   XML-THREAD   ===========================

def XMLserver(xxx):
    global SimpleXMLRPCServer
    global devList, evtList, denList, srv_sic
    print "srv:", xxx

    class EigenFunct:
        def __init__(self):
            print "Init aufgerufen (EigenFunct)"

        def event(self, E_inter, E_sernr, E_art, E_wert, *rest):
            global L_event, devices, Alarm, condSernr
            evtList.append([time.time(), E_sernr, E_art, E_wert])
            sernr= E_sernr.split(":")
            devices[sernr[0]][3][sernr[1]+":"+E_art]= [E_sernr,E_wert,time.time()]
            
            if sernr[0]== condSernr: Alarm= E_sernr, E_art, E_wert
            L_event= True
            return ''
            
        def listDevices(self, *args):
#####                  (self, DeviceDescription_Array):
            global L_event
            devList.append([args])
            print "/////   ListDevices:", args,"lang:", len(args)
            return ''

        def newDevices(self, ND_inter, ND_werte, *rest):
#####                 (self, Interface, DeviceDescription_Array):
            print "/////   New Devices - Interface:",ND_inter, "-Werte (lang):", len(ND_werte)
            print
            for zeile in ND_werte:

                if len(rest):
                    print "*********   Rest:", rest
                denList.append([ND_inter, time.time(), zeile])
            return ''

        def newDevice(self, *args):
            print "/////   newDevice-:", "lang:", len(args)
            for arg in args:
                    print "\tND:",arg
            return ''

        def deleteDevices(self, *args):
#####                    (self, Interface, SerNr_Array):
            print "/////   deleteDevices:", "lang:", len(args)
            for arg in args:
                    print "\tDelDevs:",arg
            return ''

        def updateDevice(self, *args):
#####                   (self, Interface, SerNr, UpdateHint):
            print "/////   UpdateDevice:", "lang:", len(args)
            for arg in args:
                    print "\tUD:",arg
            return ''

        def replaceDevice(self,*args):
#####                    (self, Interface, SerNrALT, SerNrNEU):
            print "/////   ReplaceDevice:", "lang:", len(args)
            for arg in args:
                    print "\tRD:",arg
            return ''

        def readdedDevice(self, *args):
#####                    (self, Interface, SerNr_Array):
            print "/////   ReaddedDevice:", "lang:", len(args)
            for arg in args:
                    print "readdedD:",arg
            return ''

    class system:
        def listMethods(self, *args):
            print "/////   listMethods:", "lang:", len(args)
            for arg in args:
    #                print "listMethods:",arg
                    print arg
            return ''


    srv = SimpleXMLRPCServer(('0.0.0.0',int(config["XMLport"])), logRequests=False)

    print ":funkt", srv.register_instance(EigenFunct())
    print ":mucal", srv.register_multicall_functions()
    
    print ":syst", srv.register_introspection_functions()

    print ":serve forever"
    try:
        srv.serve_forever()
    except:
        srv.server_close()
        print":Thread ende"



#   ********************   Hauptprogramm   ************************

Email= mail.HMmail()
XMLconfig()

print"HomeMatic- Grunddaten holen von IP-Adresse:",config["HMip"]
test = Script_Start(config["HMip"], script)

for x in test[2]:
    zeile = x.split("\t")
    if zeile[0].isdigit():
        devices[zeile[3]]= zeile[2], zeile[4], zeile[0], {}
        devnames[zeile[2]]= zeile[3]

del(test)
print "=" * 30
print

print 'Steuerung-C zum beenden'
start_new_thread(XMLserver,("xxx",))

L_event= False
Alarm= False


#   entweder 1. Seriennummer für Alarmbedingung
#condSernr= "XYZ1234567"#           Alarmbedingung HM-Gerät Seriennummer

#   oder 2. Klartext für Alarmbedingung
condName= "Licht_Kueche"#           Alarmbedingung HM-Gerät klartext
condSernr= devnames[condName]#      Alarmbedingung für Thread


ende= False
while not ende:
    try:
        time.sleep(.2)
        if L_event:
            print "L_event =>",
            print "Anzahl:", len(evtList), \
                  "\t[%04i.%02i.%02i, %02i:%02i:%02i]" % (time.localtime(time.time())[:6])
            L_event= False
            if Alarm:
                if ":" in Alarm[0]:#            Alarmbedingung weiter spezifizieren
                    print"Alarm", Alarm
                    dev= devices[Alarm[0].split(":")[0]][0]
                    Email.MailSend("***   HM-Alarm   ***", (dev+"\t%s, %s,%s" % (Alarm)))
                Alarm= False


    except KeyboardInterrupt:
        print 'Beenden'

        ende= True

ende= False
while not ende :
    print
    print" 1 = Eventliste (%i)" %(len(evtList))
    print" 2 = Neue Devices (%i)" %(len(denList))
    print" 3 = Devicestati"
    print" 4 = HM-Daten sichern"
    print
    print" 0 = Programmende"
    print
    eintast= raw_input("Auswahl: ")
    if eintast=="1":
        events(evtList, devices)

    elif eintast== "2":
        neuDevs(denList, devices)

    elif eintast== "3":
        listdev1(devices)

    elif eintast== "4":
        schreibdaten()

    elif  eintast== "0":
        ende= True
    else: print"\nEingabe nicht unterstützt\n"

eintast= raw_input("Ende mit beliebiger Taste")
