# -*- coding: utf-8 -*-
import xmlrpclib


##############################   Subroutine   ############################

def einaus(idHM, ipXmlRpcServer, portXmlServer):

    # IP & port der HomeMatic CCU
    # portHM zugriffsabhängig, BidCos-Wired = 2000, BidCos-RF = 2001, Internal = 2002

    ipHm = '192.168.178.45'#        ===== Echte HomeMatic
    #ipHm = '192.168.178.40'#        ===== LXccu Homematic
    portHm = '2001'

    # ipXmlRpcServer = '192.168.178.62'#  raspi2b-lcd (Empfänger)
    # portXmlRpcServer = '15544'#  Beliebiger, freier Port (beim Server gleichen Port verwenden!)

    # To register an xmlrpc server with Homematic set an ID 
    # To unregister leave it blank
    # idHm = 'RPI_IP_62'#     Beliebige Kennung (muß zum Start gesetzt sein)

    proxy = xmlrpclib.ServerProxy('http://'+ipHm+':'+portHm)
    print "init", proxy.init(ipXmlRpcServer+':'+portXmlServer,idHM)




#   ===========================   Hauptprogramm   =========================
config={}

try:
    eindat= open("./config_XML_RPC.txt","r")
    find= True
except:
    find= False
    print"Configdatei kann nicht gefunden werden"

if find:
    for zeile in eindat:
        if zeile[0] != "#":
            erg= zeile.strip().split(":")
            config[erg[0]]=erg[1]
            
    eindat.close()
if not find:
    eintast= raw_input("Programmabbruch! Ende mit beliebiger Taste")
    quit()


ipXmlServer = config["XMLserver"]
portXmlServer = config["XMLport"]
XMLkenn= config["XMLkenn"]

breit= 40
ende= False
while not ende:
    print"\n         XML-RPC Auswahlmenü"
    print"=" * breit
    print" 4 =  XML Empfänger-IP [%s]" % (ipXmlServer)
    print" 3 =  XML Empfänger-Port [%s]" % (portXmlServer)
    print" 2 =  XML Empfänger-Kennung [%s]" % (XMLkenn)
    print"-" * breit
    print" 1 =  XML Ein (HM-Client)"
    print" 0 =  XML Aus (HM-Client)"
    print"-" * breit
    print" 9 =  ENDE"
    eintast= raw_input("\nEingabe: ")
    if eintast.isdigit():
        eingabe= int(eintast)

        if eingabe == 4:
            einkenn= raw_input("\nNeue Adressat-IP für XML-Server [%s]: " % (ipXmlServer))
            if einkenn!= "":
                portXmlServer= einkenn

        elif eingabe == 3:
            einkenn= raw_input("\nNeuer Empfänger-Port für XML-Server [%s]: " % (portXmlServer))
            if einkenn!= "":
                portXmlServer= einkenn

        elif eingabe == 2:
            einkenn= raw_input("\nNeue Empfänger-Kennung für XML-RPC 'ein' [%s]: " % (XMLkenn))
            if einkenn!= "":
                XMLkenn= einkenn

        elif eingabe == 1:
            einaus(XMLkenn, ipXmlServer, portXmlServer); print"===== XML ein"

        elif eingabe == 0:
            einaus("", ipXmlServer, portXmlServer); print"===== XML aus"

        elif eingabe== 9: ende= True

        else:
            print"\nUnzulässige Zahl eingegeben. Bitte wiederholen\n"
    else:
        print"\nEingabe (Nichtzahl) unzulässig. Bitte wiederholen\n"
    
print "\n\nProgrammende"
eintast= raw_input("Ende mit beliebiger Taste")
