# -*- coding: utf-8 -*-
class ADC:
    def __init__(self, lcd, portas, IMP, raster):
        self.lcd= lcd
        self.portas= portas
        self.IMP= IMP
        self.raster= raster
        
        self.test= False
        #self.ref= 5.00 / 1024
        self.ref= 4.90 / 1024
        self.ADC_kanal= 2
        self.ADC_zeitbasis= .01
        self.ADC_versatz= 0
        self.Sabstand= .2
        print"ADC __init__ wude aufgerufen"

    def Vmesswerte(self, startx, starty, Sret, anf, end):
        for chan in Sret[anf:end]:
            ###self.lcd.setcol(self.lcd.farben[1])
            ###self.lcd.point(startx-15, starty+ 20+ 50* int(chan[0]-anf))
            ###self.lcd.textR("%1i " % (chan[0]))
            self.lcd.setcol(self.lcd.farben[0])
            self.lcd.point(startx, starty+ 20+ 50* int(chan[0]-anf))
            self.lcd.textR("%6.3fV" % (chan[1]))


    def werte(self, Kliste):
        ret=[]
        for chan in Kliste:
            self.portas.gpio.output(self.portas.ADC, self.portas.gpio.LOW)
            ret_AD= self.portas.spi.writebytes([0x18 | chan])
            ret_AD= self.portas.spi.readbytes(2)
            self.portas.gpio.output(self.portas.ADC, self.portas.gpio.HIGH)
            erg_neu= (ret_AD[0]<< 4) | ((ret_AD[1] & 0xf0) >> 4)
            ret.append([chan, erg_neu* self.ref])
        return ret


    def ADC_einzel(self, starty):#              Spannungs-Messung (Einzeln
        SPIhz_sic= self.portas.spi.max_speed_hz
        self.portas.spi.max_speed_hz= self.portas.spiADChz
        Sret= self.werte(range(0,8))
        self.portas.spi.max_speed_hz= SPIhz_sic

        self.lcd.fontset("r12x18")#      Messwert anzeigen
        self.lcd.setcolBG(self.lcd.farben[4])
        startx=35
        self.Vmesswerte(startx, starty, Sret, 0, 4)
        self.Vmesswerte(startx + 150, starty, Sret, 4, 8)

        self.portas.spi.max_speed_hz= SPIhz_sic


    def ADC_dauer(self, starty):#              Spannungs-Messung (Dauer)
        SPIhz_sic= self.portas.spi.max_speed_hz
        self.portas.spi.max_speed_hz= self.portas.spiADChz

        self.lcd.setcolBG(self.lcd.farben[4])
        self.lcd.fontset("r12x18")#      Messwert anzeigen
        while True:
            Sret= self.werte(range(0,8))
            startx=35
            self.Vmesswerte(startx, starty, Sret, 0, 4)
            self.Vmesswerte(startx + 150, starty, Sret, 4, 8)
            self.IMP.time.sleep(.5)

            if self.portas.taste:
                print"==>\tMeßende\n"
                self.portas.taste= None
                self.portas.spi.max_speed_hz= SPIhz_sic
                break
        print"schleife beendet"
#        ports.spi.max_speed_hz= SPIhz_sic


    def ADC_spannung(self):

        def rahmen(xstart, ystart):
            self.lcd.fill_set(1)#            Rahmen zeichnen
            xbreit= 150; ybreit= 205
            breit= 5; trenn= 50
            self.lcd.setcolBG(self.lcd.farben[3])#            BLAU
            self.lcd.box(xstart,ystart, xstart+ xbreit,ystart+ ybreit)
            self.lcd.setcolBG(self.lcd.farben[7])#            Weiss/ Grau ???
            self.lcd.setcol(self.lcd.farben[1])
            for anz in range(0,4):
                self.lcd.box(xstart+ breit,ystart+ trenn*anz+ breit, xstart+xbreit- breit,ystart+ trenn* (anz+1))
                self.lcd.point(xstart+ 15, ystart+ 20+ 50* anz)
                self.lcd.textR("%1i " % (int(anz+ (xstart> 100 and 4))))


        def rahmenM(auswahlM, multiMx, farbe):
            self.lcd.farbe= farbe
            self.lcd.box(startMx+ auswahlM* multiMx-5, startMy-3,
                    startMx+ (auswahlM+ 1) * multiMx -5, startMy + 9)


        menuADC=["Einzel-M","Dauer-M","Clear","E N D E"]
        self.lcd.TFT_del()#          TFT löschen
        starty= 15
        
        self.lcd.setcolBG(self.lcd.farben[15])
        rahmen(10, starty)#              1. Rahmen zeichnen
        rahmen(160, starty)#              2. Rahmen zeichnen

        startMx= 25; startMy= 227
        multiMx= 71
        fontSIC= self.lcd.zname
        self.lcd.fontset("r5x8")
        for x in range(0, len(menuADC)):#       Untermenpunkte
                self.lcd.point(startMx+ x* multiMx, startMy)
                self.lcd.textR(menuADC[x])
        self.lcd.fontset(fontSIC)

        auswahlM=0
        self.lcd.fill_set(False)             # Untermenü Startrahmen
        self.lcd.setcol(self.lcd.farben[0])
        colSIK= self.lcd.farbe
        rahmenM(auswahlM, multiMx, self.lcd.farbe)
        self.lcd.display()
 
        while True:
            if self.portas.taste== self.portas.T1:#         Taste 1 ==============
                self.portas.taste= False
                if self.portas.Tdauer <= .2:
                    print"Licht"
                    self.lcd.licht()

                elif self.portas.Tdauer < 1:#             Vorheriger Menüpunkt
                    rahmenM(auswahlM, multiMx, self.lcd.farbeBG)
                    auswahlM += 1
                    if auswahlM >= len(menuADC):
                        auswahlM= 0
                    self.lcd.setcol(self.lcd.farben[0])
                    rahmenM(auswahlM, multiMx, self.lcd.farbe)
                    self.lcd.display()

                elif self.portas.Tdauer >= 1:
                    print "Taste 1 >= 1 Sek / ohne Funktion"


            elif self.portas.taste== self.portas.T2:#         Taste 2 ==============
                self.portas.taste= False
                if self.portas.Tdauer <= .25:
                    print "Ausgewählt", auswahlM

                    fontSIC= self.lcd.zname# self.lcd.font
                    self.lcd.fontset("r5x8")
                    self.lcd.setcol(self.lcd.farben[3])
                    self.lcd.point(startMx+ auswahlM* multiMx, startMy)
                    self.lcd.textR(menuADC[auswahlM])
                    self.lcd.farbe= colSIK; self.lcd.fontset(fontSIC)

                    if auswahlM== 0:#                   ADC- Einzelmessung
                        bgSIK= self.lcd.farbeBG
                        self.ADC_einzel(starty)
                        self.lcd.farbeBG= bgSIK
                        self.lcd.display()
                        
                    if auswahlM== 1:#                   ADC- Dauermessung
                        bgSIK= self.lcd.farbeBG
                        self.ADC_dauer(starty)
                        self.lcd.farbeBG= bgSIK
                        self.lcd.display()

                    if auswahlM== 2:#                   Anzeige löschen
                        self.lcd.TFT_del()#          TFT löschen
                        self.lcd.setcolBG(self.lcd.farben[15])
                        rahmen(10, starty)#              1. Rahmen zeichnen
                        rahmen(160, starty)#              2. Rahmen zeichnen
                        startMx= 30; startMy= 227
                        multiMx= 70
                        fontSIC= self.lcd.zname# font
                        self.lcd.fontset("r5x8")
                        self.lcd.fill_set(False)
                        for x in range(0, len(menuADC)):
                                self.lcd.point(startMx+ x* multiMx, startMy)
                                self.lcd.textR(menuADC[x])
                        self.lcd.fontset(fontSIC)
                        self.lcd.display()

                    if auswahlM==3:#                    Hauptmenü
                        print"Ende T1"
                        break

                    fontSIC= self.lcd.zname#  .font
                    self.lcd.fontset("r5x8")
                    self.lcd.setcol(self.lcd.farben[1])
                    self.lcd.point(startMx+ auswahlM* multiMx, startMy)
                    self.lcd.textR(menuADC[auswahlM])
                    self.lcd.farbe= colSIK; self.lcd.fontset(fontSIC)
                    self.lcd.display()

                elif self.portas.Tdauer < 1:
                    rahmenM(auswahlM, multiMx, self.lcd.farbeBG)
                    auswahlM -= 1
                    if auswahlM < 0:
                        auswahlM= len(menuADC)-1
                    self.lcd.setcol(self.lcd.farben[0])
                    rahmenM(auswahlM, multiMx, self.lcd.farbe)
                    self.lcd.display()

                elif self.portas.Tdauer >= 1:
                    print"T2 >= 1 Sek / Ohne Funktion", taste.Tdauer

            self.IMP.time.sleep(.1)
        print"zurück / ende"

        self.lcd.TFT_del()
        print"zurück"


    def ADC_oszi(self):
        menuADC= ["Kanal", "Zeitbas.", "Y-Offs.", "Messung", "ENDE"]

        self.lcd.TXTmagn(1)
        #   *** Kanal (0-7), Zeitbasis (1 - .002), Y-Versatz (-5.0 ... + 5.0)
        defOSC=[[range(0,8), range(0,8)],
                [range(0,10),[1,.5,.2,.1,.05,.02,.01,.005,.002,.001]],
                [range(0,101),range(-50,50)]]
        for x in range(0,len(defOSC[2][1])):
                defOSC[2][1][x] /= 10.0
        self.defKanal= 2
        self.defTbase= 6
        self.defYoff= 50
        self.defadc=defOSC

        def rahmen(xstart, ystart):
            self.lcd.fill_set(1)#            Rahmen zeichnen
            xbreit= 150; ybreit= 205
            breit= 5; trenn= 50
            self.lcd.setcolBG(self.lcd.farben[3])
            self.lcd.box(xstart,ystart, xstart+ xbreit,ystart+ ybreit)
            self.lcd.setcolBG(self.lcd.farben[7])
            self.lcd.setcol(self.lcd.farben[1])
            for anz in range(0,4):
                self.lcd.box(xstart+ breit,ystart+ trenn*anz+ breit, xstart+xbreit- breit,ystart+ trenn* (anz+1))
                self.lcd.point(xstart+ 15, ystart+ 20+ 50* anz)
                self.lcd.textR("%1i " % (int(anz+ (xstart> 100 and 4))))


        def rahmenM(auswahlM, multiMx, farbe):
            self.lcd.farbe= farbe
            self.lcd.box(startMx+ auswahlM* multiMx-5, startMy-3,
                    startMx+ (auswahlM+ 1) * multiMx -5, startMy + 9)


        def naviminus(startMx, multiMx, startMy, auswahlM, art, vari):
            vari -= 1
            if vari < 0:
                vari= self.defadc[art][0][-1]

            variADC = self.defadc[art][1][vari]
            fontSIC= self.lcd.zname
            self.lcd.fontset("r5x8")
            self.lcd.point(startMx+ auswahlM* multiMx, startMy+ 10)
            self.lcd.textR(str(variADC).rjust(5))
            self.lcd.fontset(fontSIC)
            return vari, variADC


        def naviplus(startMx, multiMx, startMy, auswahlM, art, vari):
            vari += 1
            if vari > self.defadc[art][0][-1]:
                vari= self.defadc[art][0][0]

            variADC = self.defadc[art][1][vari]
            fontSIC= self.lcd.zname
            self.lcd.fontset("r5x8")
            self.lcd.point(startMx+ auswahlM* multiMx, startMy+ 10)
            self.lcd.textR(str(variADC).rjust(5))
            self.lcd.fontset(fontSIC)
            return vari, variADC



        def select(startMx, auswahlM, multiMx, startMy):
            self.lcd.farbe= Mfarbe
            self.lcd.point(startMx+ auswahlM* multiMx, startMy)
            fontSIC= self.lcd.zname
            self.lcd.fontset("r5x8")
            self.lcd.textR(menuADC[auswahlM])
            self.lcd.fontset(fontSIC)


        #***************   SUB-Start   **********************************

        self.lcd.TFT_del()#          TFT löschen
        starty= 15
        
        self.lcd.setcolBG(self.lcd.farben[15])

        startMx= 7; startMy= 220
        multiMx= 67
        self.lcd.setcol(self.lcd.farben[0]); Mfarbe= self.lcd.farbe
        fontSIC= self.lcd.zname
        self.lcd.fontset("r5x8")
        for x in range(0, len(menuADC)):#       Untermenüpunkte
                self.lcd.point(startMx+ x* multiMx, startMy)
                self.lcd.textR(menuADC[x])
                if x <3:
                    if x==0: text= self.ADC_kanal
                    elif x==1: text= self.ADC_zeitbasis
                    elif x==2: text= self.ADC_versatz
                    self.lcd.point(startMx+ x* multiMx, startMy+ 10)
                    self.lcd.textR(str(text).rjust(5))
        self.lcd.fontset(fontSIC)

        auswahlM=0

        self.lcd.fill_set(False)             # Untermenü Startrahmen
        self.lcd.setcol(self.lcd.farben[0])
        colSIK= self.lcd.farbe
        rahmenM(auswahlM, multiMx, self.lcd.farbe)#        Untermenü 1. Rahmen
        self.lcd.display()

        self.portas.taste= None
        while True:
            if self.portas.taste== self.portas.T1:#         Taste 1 ==============
                self.portas.taste= None
                if self.portas.Tdauer <= .25:#  Licht
                    self.lcd.licht()

                elif self.portas.Tdauer < 1:#     Menü-Navigation
                    print"Navigation +",
                    rahmenM(auswahlM, multiMx, self.lcd.farbeBG)#     Rahmen löschen
                    auswahlM += 1
                    if auswahlM >= len(menuADC):
                        auswahlM= 0
                    self.lcd.setcol(self.lcd.farben[0])
                    rahmenM(auswahlM, multiMx, self.lcd.farbe)#       Rahmen neu
                    self.lcd.display()

                elif self.portas.Tdauer >= 1:
                    print "Taste >= 1 Sek. / Hardcoopy gestartet", self.portas.Tdauer
                    self.raster("Oszi", 2,2)

            elif self.portas.taste== self.portas.T2:#         Taste 2 ==============
                self.portas.taste = None
                if self.portas.Tdauer <= .25:#  Auswahl
                    print "Auswahl"
                    fontSIC= self.lcd.zname# .font
                    self.lcd.fontset("r5x8")
                    self.lcd.setcol(self.lcd.farben[1])
                    self.lcd.point(startMx+ auswahlM* multiMx, startMy)
                    self.lcd.textR(menuADC[auswahlM])
                    self.lcd.farbe= colSIK; self.lcd.fontset(fontSIC)
                    self.lcd.display()


                    if auswahlM== 0:#            Kanal
                        print"Kanal / defkanal",self.defKanal
                        art= 0
                        while True:
                            if self.portas.taste:
                                Taste= self.portas.taste; Dauer= self.portas.Tdauer
                                self.portas.taste= None
                                if Taste== self.portas.T1:#     Taste 1
                                    if Dauer <= .25:#        Licht
                                        print "Licht"
                                        self.lcd.licht()
                                        
                                    elif Dauer < 1:#         Navigation
                                        print"Navigation + ",
                                        self.defKanal, self.ADC_kanal= naviplus(startMx, multiMx, startMy, auswahlM, art, self.defKanal)
                                        self.lcd.display()

                                
                                elif Taste== self.portas.T2:#     Taste 2
                                    if Dauer <= .25:#        Auswahl/ Select
                                        select(startMx, auswahlM, multiMx, startMy)
                                        self.lcd.display()
                                        break

                                    elif Dauer < 1:#         Navigation
                                        print"Navigation - ",
                                        self.defKanal, self.ADC_kanal= naviminus(startMx, multiMx, startMy, auswahlM, 0, self.defKanal)
                                        self.lcd.display()

                            self.IMP.time.sleep(.1)

                    if auswahlM== 1:#            Zeitbasis
                        print "defzeitbasis",self.defTbase
                        art= 1
                        while True:
                            if self.portas.taste:
                                Taste= self.portas.taste; Dauer= self.portas.Tdauer
                                self.portas.taste= None
                                if Taste== self.portas.T1:#     Taste 1
                                    if Dauer <= .25:#        Licht
                                        print "Licht"
                                        self.lcd.licht()
                                        
                                    elif Dauer < 1:#         Navigation
                                        print"Navigation + ",
                                        self.defTbase, self.ADC_zeitbasis= naviplus(startMx, multiMx, startMy, auswahlM, art, self.defTbase)
                                        self.lcd.display()

                                
                                elif Taste== self.portas.T2:#     Taste 2
                                    if Dauer <= .25:#        Auswahl/ Select
                                        select(startMx, auswahlM, multiMx, startMy)
                                        self.lcd.display()
                                        break

                                    elif Dauer < 1:#         Navigation
                                        print"Navigation - ",
                                        self.defTbase, self.ADC_zeitbasis= naviminus(startMx, multiMx, startMy, auswahlM, art, self.defTbase)
                                        self.lcd.display()
                            self.IMP.time.sleep(.1)


                    if auswahlM== 2:#            Y-Versatz
                        print "Y-Offset",self.defYoff
                        while True:
                            if self.portas.taste:
                                Taste= self.portas.taste; Dauer= self.portas.Tdauer
                                self.portas.taste= None
                                if Taste== self.portas.T1:#     Taste 1
                                    if Dauer <= .25:#        Licht
                                        print "Licht"
                                        self.lcd.licht()
                                        
                                    elif Dauer < 1:#         Navigation
                                        print"Navigation + ",
                                        self.defYoff, self.ADC_versatz= naviplus(startMx, multiMx, startMy, auswahlM, auswahlM, self.defYoff)
                                        self.lcd.display()

                                
                                elif Taste== self.portas.T2:#     Taste 2
                                    if Dauer <= .25:#        Auswahl/ Select
                                        select(startMx, auswahlM, multiMx, startMy)
                                        self.lcd.display()
                                        break

                                    elif Dauer < 1:#         Navigation
                                        print"Navigation - ",
                                        self.defYoff, self.ADC_versatz= naviminus(startMx, multiMx, startMy, auswahlM, auswahlM, self.defYoff)
                                        self.lcd.display()

                            self.IMP.time.sleep(.1)

                    if auswahlM== 3:#            Messung
                        if self.test:
                            print"Messungen:\t", 
                        if self.ADC_zeitbasis >.1:
                            print"Direktanzeige"
                            self.lcd.fill_set(True)#        alten Anzeigebereich löchen
                            self.lcd.box(0,0,319,215)
                            self.lcd.setcolBG([0x1f,0x2f,0x1f])
                            self.lcd.fill_set(False)

                            self.Oszi([self.ADC_kanal], self.ADC_zeitbasis, self.ADC_versatz, 1)
                            self.lcd.display()

                        elif self.ADC_zeitbasis >= .0002:
                            print "Speichermessung!"
                            self.lcd.penBG(7)
                            self.lcd.fill_set(True)#        alten Anzeigebereich löchen
                            self.lcd.box(0,0,319,215)
                            self.lcd.fill_set(False)

                            self.OsziMEM([self.ADC_kanal], self.ADC_zeitbasis, self.ADC_versatz)
                            self.lcd.display()

                        else:
                            print "Eingabe ungültig (Zeitbasis < 0.0002 Sek. nicht zuverlässig!)"

#                        print"*******   Endrahmen zeichnen   *********"
                        self.lcd.farbe= Mfarbe
                        self.lcd.point(startMx+ auswahlM* multiMx, startMy)
                        fontSIC= self.lcd.zname
                        self.lcd.fontset("r5x8")
                        self.lcd.textR(menuADC[auswahlM])
                        self.lcd.fontset(fontSIC)
                        self.lcd.display()


                    if auswahlM== 4:#            EnDE
                        print"===>\tzurück"
                        break


                elif self.portas.Tdauer < 1:#     Menü-Navigation
                    print"Navigation -",

                    rahmenM(auswahlM, multiMx, self.lcd.farbeBG)#     Rahmen löschen
                    auswahlM -= 1
                    if auswahlM < 0:
                        auswahlM= len(menuADC)-1
                        self.lcd.display()
                    print auswahlM

                    self.lcd.setcol(self.lcd.farben[0])
                    rahmenM(auswahlM, multiMx, self.lcd.farbe)#       Rahmen neu
                    self.lcd.display()


                elif self.portas.Tdauer >= 1:#  leer
                    print "Taste >= 1 Sek. / HardCopy gestartet", self.portas.Tdauer
                    self.raster("Oszi", 2,2)
            self.IMP.time.sleep(.1)



    def ADC_werte(self, Verg, TBeinzel, timebase):
        Werte=[]
        start= None
        stop= None
        for x in Verg:
            Werte.append(x[0][1])

        summe= sum(Werte)
        anzahl= len(Werte)
        mittel=summe/float(anzahl)
        Tmin=[[],[]]
        Tmax=[[],[]]
        for x in range (0,len(Werte)):
            if Werte[x]< mittel:
                Tmin[0].append(Werte[x])#       Min/ Max-Tabellen erzeugen
                Tmin[1].append(x)
            if Werte[x]>= mittel:
                Tmax[0].append(Werte[x])
                Tmax[1].append(x)
        if len(Tmin[0])> 0:
            ret_Min= min(Tmin[0])
        else:
            ret_Min=0

        if len(Tmax[0])> 0:
            ret_Max= max(Tmax[0])
        else:
            ret_Max= 0

        syncProz= 1.5#        5
        minDif= 0.090

        maxi= mittel* (1-syncProz/100.0)#   Spannungsmittel minus Toleranz
        mini= mittel* (1+syncProz/100.0)#   Spannungsmittel plus Toleranz
        if self.test:
            print"maxi", maxi
            print"mini", mini
            print "retmax", ret_Max, "retmin", ret_Min,"dif", ret_Max - ret_Min 
 

        if ret_Max - ret_Min >= minDif:
            print"+++++++++++++++++++++++++++++++"
            minD=0; minA=0#     Dauer, Anzahl Minimum
            minStart=0
            for x in range(0,len(Tmin[1])-1):
                if abs(Tmin[1][x]-Tmin[1][x+1])> 1:
                    minA += 1
                    minL = x- minStart
                    minStart= x
                    minD += minL
                    minStart= x
            minP2= minD/float(minA)
            if self.test:
                print "minD, minA:",minD, minA, "minDauer:", minP2

            maxD=0; maxA=0#     Dauer, Anzahl Maximum
            maxStart=0
            for x in range(0,len(Tmax[1])-1):
                if abs(Tmax[1][x]-Tmax[1][x+1])> 1:
                    maxA += 1
                    maxL = x- maxStart
                    maxStart= x
                    maxD += minL
                    maxStart= x
            maxP2= maxD/float(maxA)

            if self.test:
                print "maxD, maxA:",maxD, maxA, "maxDauer:", maxP2
                print"Time/ Time_Bild:", timebase, timebase*7

            wertAnz=len(Tmin[1])+ len(Tmax[1])
            mittel= timebase*7.0 /float(wertAnz)
            if self.test:
                print"mittel:",mittel
            periode= (minP2 + maxP2)* mittel
            ret_f= 1/periode

            if self.test:
                print"Periode:", periode
            print "Frequenz:", ret_f

            if self.test:
                print "min(Tmax), maxi, mittel, 1-syncProz/float(100)"
                print min(Tmax), maxi,mittel,  1-syncProz/float(100)
                print "mittel, max(Tmin), mini, 1+ syncProz/float(100)"
                print mittel,max(Tmin), mini, 1+ syncProz/float(100)

            if self.test:
                mittel_= (Umax + Umin)/ 2
                print"Mittel_:", mittel_
                print"Vmax:", Umax
                print "Vmin:", Umin
                print"sum(Tmax), anz(Tmax):", sum(Tmax), len(Tmax)
                print"sum(Tmin), anz(Tmin):", sum(Tmin), len(Tmin)

        else:
            ret_f= 0
            print"------------ null"

        print"ret:", ret_f, ret_Min, ret_Max
        return True, ret_f, ret_Min, ret_Max

    def Oszi(self,kanal, timebase, freq, ratio):
        self.lcd.setcol(self.lcd.farben[0])
#        self.lcd.fontset("v5x7")
        self.lcd.fontset("v3x6")

        xstart=30; ystart=200
        scalx=10
        anzahl= 245; multix= 35.0; mbereich= 5

        self.lcd.line(xstart, ystart, xstart+ anzahl, ystart)#   Zeitlinie (X)
        self.lcd.line(xstart,ystart,
                 xstart, int(ystart- (mbereich* multix)))# Spannung (Y)
        for x in xrange(0, mbereich+ 1):#                      Y Scala
            ypoint=ystart- int(x * multix)
            self.lcd.line(xstart+4, ypoint, xstart-scalx+4, ypoint)
            self.lcd.point(xstart-15, ypoint+2)
            self.lcd.textV(str(x))
            if x+.5 <= mbereich:
                ypoint=ystart- int(x * multix + multix/2)
                self.lcd.line(xstart+4, ypoint, xstart, ypoint)

        for x in range(0, int(anzahl + multix), int(multix+.5)):# X Scala
            self.lcd.line(xstart + x, ystart-3, xstart+x, ystart +7)
            self.lcd.point(xstart+x-10, ystart+ 12)
            self.lcd.textV(str(x/multix* timebase))

        TBeinzel= timebase / multix
        tstart= self.IMP.time.time()
        altzeit=tstart
        tstart=self.IMP.time.time()

        SPIhz_sic= self.portas.spi.max_speed_hz
        self.portas.spi.max_speed_hz= self.portas.spiADChz
        for x in xrange(0,anzahl):#                 Anzahl Messungen
            TBalt=self.IMP.time.time()
            Verg= self.werte(kanal)

            for chan in Verg:#                      Alle Kanäle
                self.lcd.setcol(self.lcd.farben[chan[0] +1])
                xpos= x+ xstart
                ypos= ystart- int(float(chan[1])* multix)
                self.lcd.line(xpos,ypos, xpos,ypos)
            neuzeit= self.IMP.time.time()
#           'multix' Messwerte pro Zeiteinheit (timebase)
            while (self.IMP.time.time()- TBalt) < TBeinzel:#        Zeitbasis-Schleife
                pass
            TBalt= self.IMP.time.time()

        self.portas.spi.max_speed_hz= SPIhz_sic
        tende= self.IMP.time.time()
        print"dauer:", tende-tstart
#        ret_aus= ADCauswertung(Verg)
        if self.test:
            print"Returnwert spannung:", ret_aus



    def OsziMEM(self,kanal, timebase, yversatz):
        self.lcd.setcol(self.lcd.farben[0])
        self.lcd.fontset("v3x6")

#        xstart=30; ystart=200
        xstart=20; ystart=195#  200
        scalx=10
        divAnzahl= 8#       7
#        anzahl= 245; multix= 35.0; mbereich= 5
        multix= 35.0; mbereich= 5
        anzahl= int(divAnzahl* multix)

        self.lcd.line(xstart, ystart, xstart+ anzahl, ystart)#   Zeitlinie (X)
        self.lcd.line(xstart,ystart,
                 xstart, int(ystart- (mbereich* multix)))# Spannung (Y)
        for x in xrange(0, mbereich+ 1):#                      Y Scala
            ypoint=ystart- int(x * multix)
            self.lcd.line(xstart+4, ypoint, xstart-scalx+4, ypoint)
            self.lcd.point(xstart-15, ypoint+2)
            self.lcd.textV(str(x))
            if x+.5 <= mbereich:
                ypoint=ystart- int(x * multix + multix/2)
                self.lcd.line(xstart+4, ypoint, xstart, ypoint)

###        print "====>   Zeitbasis:", timebase
        if timebase >= .1:
            einheit="S"
            xbase= timebase
        elif timebase >= 0.00005:
            einheit="mS"
            xbase= int(timebase * 1000)
        else:
            einheit="µS"
            xbase= int(timebase * 1000)

        for x in range(0, int(anzahl + multix), int(multix+.5)):# X Scala
            self.lcd.line(xstart + x, ystart-3, xstart+x, ystart +7)
            self.lcd.point(xstart+x-10, ystart+ 12)
            self.lcd.textV(str(x/multix* xbase))

        self.lcd.point(xstart+120, ystart+ 19)
        self.lcd.textV("["+ str(einheit)+ "]")

        SPIhz_sic= self.portas.spi.max_speed_hz
        self.portas.spi.max_speed_hz= self.portas.spiADChz

        TBeinzel= timebase / multix
        tstart= self.IMP.time.time()
        altzeit=tstart
        tstart= self.IMP.time.time()

        Verg=[]
        for x in xrange(0,anzahl):#                 Anzahl Messungen (Daten holen)
            TBalt= self.IMP.time.time()
            Verg.append(self.werte(kanal))
            while (self.IMP.time.time()- TBalt) < TBeinzel:#        Zeitbasis-Schleife
                pass
            TBalt= self.IMP.time.time()

        tende= self.IMP.time.time()
        self.portas.spi.max_speed_hz= SPIhz_sic

        for kanal in range(0, len(Verg[0])):
            ypos= ystart- int(float(Verg[0][kanal][1] + yversatz)* multix)
            self.lcd.point(xstart, int(ypos))

            for x in range(1, len(Verg)-1):#          Anzahl Messungen (TFT-Anzeige)
                self.lcd.setcol(self.lcd.farben[kanal +1])
                xpos= xstart+ x
                chan=Verg[x][kanal]
                ypos= ystart- int(float(chan[1] + yversatz)* multix)
                self.lcd.line(xpos,ypos)
        ret_aus= self.ADC_werte(Verg, TBeinzel, timebase)
        
        if self.test:
            print"Returnwert Spannung:", ret_aus

        if ret_aus[0]== True:
            Dfreq= "%4.0f" % (ret_aus[1])
            Dmin= "%5.3f" % (ret_aus[2])
            Dmax= "%5.3f" % (ret_aus[3])
            
        else:
            Dfreq= "---"
            Dmin= "---"
            Dmax= "---"
            
        self.lcd.fontset("v5x7")
        self.lcd.setcol(self.lcd.farben[0])

        self.lcd.point(5,10)
        self.lcd.textV("Freq:"+ Dfreq)

        self.lcd.point(110,10)
        self.lcd.textV("Umin:"+ Dmin)

        self.lcd.point(225,10)
        self.lcd.textV("Umax:"+ Dmax)
        self.lcd.display()
