# -*- coding: utf-8 -*-
class TFTtests():
    def __init__(self, lcd, common, IMP, portas):
        print "test __init__ wurde aufgerufen"
        self.lcd= lcd
        self.common= common
        self.IMP= IMP
        self.portas= portas
        
    def test_farbverlauf(self):
        xstart=0; xbreit=10
        ystart=10; yhoch=25
        yleer= 10
        xmax= 160
        werte=[[],[],[]]

    #   Farb-Vorbereitung
        for fpal in range(0x1f, -1, -1):
            werte[0] += [(fpal << 3), 0]* xbreit#                           ROT
            werte[2] += [0, fpal]* xbreit#                                  Blau
        for fpal in range(0x3f, -1, -1):#                                   Grün
            werte[1] += [((fpal & 0x38) >>3), (fpal & 0x07) << 5]* xbreit

        for Floop in werte:#    Hauptschleife (Rot/ Grün/ Blau)
            for x in range (0, len(Floop), xmax* 2):
                daten= Floop[x: x+ xmax* 2]
                for yadd in range(0, yhoch):
                    self.lcd.screen[ystart + yadd][xstart*2:xstart*2+ len(daten)]= daten
                ystart += yhoch
            ystart += yleer
        del(werte)

    #   Farb-Vorbereitung (Graustufen)
        daten=[]
        for fpal in range(0x1f, -1, -1):
            wertR = fpal << 3#                           ROT
            wertB = fpal#                                  Blau
            wertG0 = ((fpal*2) & 0x38) >>3#                Grün
            wertG1 = ((fpal*2) & 0x07) << 5
            
            erg= wertR | wertG0, wertG1| wertB
            daten += erg* xbreit

        xstart= 160
        ystart= 10

        for x in range (0, len(daten), xmax* 2):
            daten1= daten[x: x+ xmax* 2]
            for yadd in range(0, yhoch):
                self.lcd.screen[ystart + yadd][xstart* 2:xstart* 2+ len(daten1)]= daten1
            ystart += yhoch
        ystart += yleer
        del(daten)

    #   Farb-Vorbereitung (rot/ grün)
        daten=[]
        for fpal in range(0x1f, -1, -1):
            wertR = fpal << 3#                           ROT
            wertB = 0#                                  Blau
            wertG0 = ((fpal*2) & 0x38) >>3#                Grün
            wertG1 = ((fpal*2) & 0x07) << 5
            
            erg= wertR | wertG0, wertG1| wertB
            daten += erg* xbreit

        xstart= 160
        ystart= 70

        for x in range (0, len(daten), xmax* 2):
            daten1= daten[x: x+ xmax* 2]
            for yadd in range(0, yhoch):
                self.lcd.screen[ystart + yadd][xstart* 2:xstart* 2+ len(daten1)]= daten1
            ystart += yhoch
        ystart += yleer
        del(daten)

    #   Farb-Vorbereitung (rot/ blau)
        daten=[]
        for fpal in range(0x1f, -1, -1):
            wertR = fpal << 3#                           ROT
            wertB = fpal#                                  Blau
            wertG0 = 0#                Grün
            wertG1 = 0
            
            erg= wertR | wertG0, wertG1| wertB
            daten += erg* xbreit

        xstart= 160
        ystart= 120

        for x in range (0, len(daten), xmax* 2):
            daten1= daten[x: x+ xmax* 2]
            for yadd in range(0, yhoch):
                self.lcd.screen[ystart + yadd][xstart* 2:xstart* 2+ len(daten1)]= daten1
            ystart += yhoch
        ystart += yleer
        del(daten)

    #   Farb-Vorbereitung (gelb/ blau)
        daten=[]
        for fpal in range(0x1f, -1, -1):
            wertR = 0#                           ROT
            wertB = fpal#                                  Blau
            wertG0 = ((fpal*2) & 0x38) >>3#                Grün
            wertG1 = ((fpal*2) & 0x07) << 5
            
            erg= wertR | wertG0, wertG1| wertB
            daten += erg* xbreit

        xstart= 160
        ystart= 180
        for x in range (0, len(daten), xmax* 2):
            daten1= daten[x: x+ xmax* 2]
            for yadd in range(0, yhoch):
                self.lcd.screen[ystart + yadd][xstart* 2:xstart* 2+ len(daten1)]= daten1
            ystart += yhoch
        ystart += yleer
        del(daten)


    def readmem(self, anzahl):
        global MRerg
        ports.schreibe(0x3a,[0x66])
        sammel=[]
        for loop in range(0,anzahl):
            self.lcd.point(0,loop)
            sammel += ports.lese(0x2e, 320*3)[1]
            ports.schreibe(0x00,[])

        ports.schreibe(0x3a,[0x55])
        sammel1= memauswert(sammel)
        return sammel, sammel1

    def memauswert(self, MRerg):
        erg=MRerg[1:]
        sammel=""
        for x in range(0, len(erg),3):
            if x+2 < len(erg):
                daten= erg[x]+ erg[x+1]+erg[x+2]
                if daten: sammel +="X"
                else: sammel+="."
        return sammel


    def test_gitter(self):
        self.lcd.fill_set(0)
        step= 5
        daten= [0xff, 0xff]* self.lcd.maxX
        for y in range(step,self.lcd.maxY, step):
            self.lcd.point(0,y)
            self.lcd.screen[y][0:0+len(daten)]= daten
        self.lcd.box(0,0,319,239)

        self.lcd.setcol(self.lcd.farben[7])
        for x in range(step, self.lcd.maxX, step):
            self.lcd.line(x,0, x, self.lcd.maxY)
            

    def test_lines(self):#************************   Linien   *********************
        self.lcd.line(10,50, 300,200)#       X ganzer Bildschirm
        self.lcd.line(10,200, 300,50)

        self.lcd.fill_set(1)
        self.lcd.setcolBG(self.lcd.farben[1])#    Box zeichnen
        self.lcd.box(25,55, 255,135)
        self.lcd.setcolBG(self.lcd.farben[15])
        self.lcd.box(35,65, 245,125)

        self.lcd.fill_set(1)
        self.lcd.setcolBG(self.lcd.farben[2])#    Kreise zeichnen
        for x in range(0,5):
            for f in self.lcd.farbeBG:
                self.lcd.farbeBG[1] -= ((x* 2))
                self.lcd.farbeBG[0] += ((x*2)<< 3)
            self.lcd.circle(200,180, 50-x*10)

        xbreit=20; xabstand=30
        ystart=15; ybreit=25
        self.lcd.fill_set(1)
        self.lcd.setcolBG(self.lcd.farben[3])
        for x in range(0,10):
            self.lcd.farbeBG[0] |= int(x*3) << 3
            self.lcd.box(10+ x*xabstand,ystart, 10+x* xabstand+ xbreit,ystart+ ybreit)

        self.lcd.fill_set(0)


    def test_vtext(self, ):#************************   V-Text   ***********************
        def text(posx,posy,Text, multi):
            self.lcd.TXTmagn(multi)
            self.lcd.point(posx, posy)
            self.lcd.textV(Text)


        print"test: V-Text"
        self.lcd.fontset("v3x6")
        self.lcd.setcol(self.lcd.farben[3])
        print"Farbe:", self.lcd.farbe
        xstart= 10
        ystart= 25
        multi= 1
        txt="(C) 2016 / J.Hoppe"
        text(xstart, ystart,txt, multi)

        multi= 2
        text(xstart,ystart+ 25,txt, multi)
        self.lcd.setcol(self.lcd.farben[1])
        self.lcd.fontset("v5x7")
        text(xstart, ystart+ 55, txt, multi)

        txt="(C) 2016"
        multi= 3
        text(xstart, ystart+ 85,txt, multi)

        multi= 4
        text(xstart, ystart+ 115,txt, multi)

        multi= 5
        text(xstart, ystart+ 155,txt, multi)



    def test_rtext(self):#************************   R-Text   ***********************
        def text(xstart, ystart, txt, farbe, mag):
            self.lcd.TXTmagn(mag)
            self.lcd.setcol(self.lcd.farben[farbe])
            self.lcd.point(xstart, ystart)
            self.lcd.textR(txt)


        self.lcd.fontset("r5x8")
        posx= 10; posy= 10
        self.lcd.TXTmagn(1)
        txt="C 2016 / Jürgen Hoppe"
        text(posx, posy, txt, 0, 1)
        txt="C 2016 / J. Hoppe"
        text(posx, posy+13, txt, 0, 2)
        txt="C 2016 / J.H."
        text(posx, posy+35, txt, 0, 3)

        self.lcd.fontset("r10x14")
        posx= 20; posy= 70#         80
        txt="C 2016 / J. Hoppe"
        text(posx, posy, txt, 1, 1)
        txt="C 2016 J. H."
        text(posx, posy+19, txt, 1, 2)

        self.lcd.fontset("r12x18")
        posx= 10; posy= 120#        140
        txt="C 2016"
        text(posx, posy, txt, 3, 1)

        xstart= posx+110; ystart= posy
        txt="Hoppe"
        text(xstart, ystart, txt, 0, 2)

        xstart= posx; ystart= posy+ 45
        txt="Jürgen"
        text(xstart, ystart, txt, 10, 3)



    def reg_disp(self, ret_reg):
        print "\t",
        for x in ret_reg[1:]:
            print hex(x),
        print


    def test_regread(self):#********************   Register auslesen   **************
        #       1= LCD-Hersteller/ 2= Version Modukl, Treiber/ 3=  Modul, Treiber
        #   "Text", REG, ByteAnz, GPIO Board PIN
        speedSIC= ports.spi.max_speed_hz
        ports.spi.max_speed_hz = ports.spiREADhz
        ret_reg= ports.lese(0x04, 3)#   RDDid'       lies ID (1-3) default (85h, 85h, 52h)
        reg_disp(ret_reg)

        ret_reg= ports.lese(0xDA, 1)#   RDid1'       lies Display ID1
        reg_disp(ret_reg)
        ret_reg= ports.lese(0xDB, 1)#   RDid2'       lies Display ID2
        reg_disp(ret_reg)
        ret_reg= ports.lese(0xDC, 1)#   RDid3'       lies Display ID3
        reg_disp(ret_reg)

        ret_reg= ports.lese(0x09, 4)#   RDDst'       lies Display-Status
        reg_disp(ret_reg)
        ret_reg= ports.lese(0x0A, 1)#   RDDpm'       lies Display Power-Mode
        reg_disp(ret_reg)
        ret_reg= ports.lese(0x0C, 1)#   RDDcolMOD'   lies Display Color-Mode
        reg_disp(ret_reg)
        ret_reg= ports.lese(0x0D, 1)#   RDDím'       lies Display Image-Mode
        reg_disp(ret_reg)
        ret_reg= ports.lese(0x0f, 1)#   RDDsdr
        reg_disp(ret_reg)
        ports.spi.max_speed_hz = speedSIC


    def test_balken(self):#*********************   Farbbalken   **********************
        lcdxstart= 5
        lcdystart= 30
        
        xstart_sic= lcdxstart
        ystart_sic= lcdystart

        fzeile=[]
        for x in range(0, len(self.lcd.farben)):
            self.lcd.setcol(self.lcd.farben[x])

            fwerte= 25 * self.lcd.farbe
            fzeile += 10 * self.lcd.farbe
            for y in range(0,25):#          *********  vertikal
                pX=lcdxstart* 2
                pY= lcdystart
                self.lcd.screen[pY][pX:pX+ len(fwerte)]= fwerte#        RAMwr
                lcdystart += 1

            if divmod(x+1 , (len(self.lcd.farben)/4))[1]== 0:
                lcdystart=ystart_sic
                lcdxstart += 95#   120

        for y in range(0,20):#              *********  horizontal
            pX= 0
            pY= 0+ y
            self.lcd.screen[pY][pX:pX+ len(fzeile)]= fzeile#           RAMwr
        self.lcd.display()


    def test_lines_xgey(self):#                   divx >= divY (line)
        self.lcd.line(10,10,100,10)
        self.lcd.line(100,10,110,20)
        self.lcd.line(110,20,100,30)
        self.lcd.line(100,30,110,40)
        self.lcd.line(110,40,100,50)
        self.lcd.line(100,50,10,50)
        self.lcd.line(10,50,0,40)
        self.lcd.line(0,40,10,30)
        self.lcd.line(10,30,0,20)
        self.lcd.line(0,20,10,10)

    def test_lines_ygtx(self):#                   divY > divX (line)
        self.lcd.line(10,10, 50,10)
        self.lcd.line(50,10, 60,30)
        self.lcd.line(60,30, 50,50)
        self.lcd.line(50,50, 60,70)
        self.lcd.line(60,70, 50,90)
        self.lcd.line(50,90, 10,90)
        self.lcd.line(10,90, 0,70)
        self.lcd.line(0,70, 10,50)
        self.lcd.line(10,50, 0,30)
        self.lcd.line(0,30, 10,10)

    def tests(self, teil, common, Rhoch):
        deftest=[[2,"Linien y>=y"],[3,"Linien x<Y"],[4, "Linien"],
                 [6,"Text (Vektor)"],[7, "Text (Raster)"],[8, "Gittermuster"],
                 [10, "TFT invers"],[11, "Farbpalette"],[12, "Farbverlauf"]]

        MXbreit= 270; MXstart= 30
        Rbreit= 10; Zabstand= 25
        if teil== 1:
            MYhoch= 210; MYstart= 20
            Mtext= "LCD-Tests 1"
            menu=deftest[:5]; menu.append([1,"Zurück"])
        else:
            MYhoch= 190; MYstart= 40
            Mtext= "LCD-Tests 2"
            menu=deftest[5:]; menu.append([1,"Zurück"])

        common.menuMain(MXbreit, MXstart, MYhoch, MYstart, Rbreit, Zabstand, menu, Mtext)
        self.lcd.display()

        self.lcd.fill_set(False)
        self.lcd.setcol(self.lcd.farben[1])

        auswahlM=0
        common.Mrahmen(self.lcd.farbe, auswahlM, MYstart, Zabstand, Rhoch, MXstart, Rbreit, MXbreit)
        self.lcd.display()
        self.portas.taste= None
        while True:
            if self.portas.taste:
                Taste= self.portas.taste; Dauer= self.portas.Tdauer
                self.portas.taste= None
                if Taste== self.portas.T1:#           ================   Taste-1
                    if Dauer <= .2:#            Licht
                        self.lcd.licht()

                    elif Dauer < 1:#              Navigation +
                        auswahlM= common.naviP(self.lcd, auswahlM, len(menu), MYstart, Zabstand, Rhoch, MXstart, Rbreit, MXbreit)
                        self.lcd.display()

                if Taste== self.portas.T2:#           ================   Taste-2
                    if Dauer <= .2:#            Auswahl
                        if teil== 1:
                            print "Teil 1/ auswahlM", auswahlM
                            self.lcd.TFT_del()
                            if auswahlM== 0:
                                self.lcd.setcol(self.lcd.farben[3])
                                self.test_lines_xgey()#    divx >= divY (line)
                                self.lcd.display()
                            elif auswahlM== 1:
                                self.lcd.setcol(self.lcd.farben[3])
                                self.test_lines_ygtx()#    divY > divX (line)
                                self.lcd.display()
                            elif auswahlM== 2:
                                self.test_lines()#***********   Linien   **************
                                self.lcd.display()
                            elif auswahlM== 3:
                                self.lcd.setcol(self.lcd.farben[0])                                
                                self.test_vtext()#***********   V-Text   **************
                                self.lcd.display()
                            elif auswahlM== 4:
                                self.lcd.setcol(self.lcd.farben[3])
                                self.test_rtext()#***********   R-Text   **************
                                self.lcd.display()
                            elif auswahlM== 5:
                                break#          ***********   Zurück   ********

                        elif teil== 2:
                            print "Teil 2/ auswahlM", auswahlM
                            if auswahlM== 0:
                                self.lcd.TFT_del(farbe=[0,0])
                                self.lcd.setcol(self.lcd.farben[0])
                                self.test_gitter()#                  Gittermuster
                                self.lcd.display()

                            elif auswahlM== 1:#                 Invers
                                self.lcd.Invers= not self.lcd.Invers
                                self.portas.invers(self.lcd.Invers)#                            Invers aus
                                self.lcd.display()

                            elif auswahlM== 2:
                                self.lcd.TFT_del()
                                self.test_balken()#**********   Farbbalken   **********
                                self.lcd.display()

                            elif auswahlM== 3:
                                self.lcd.TFT_del()
                                self.test_farbverlauf()#********   Farbverlauf   ***
                                self.lcd.display()

                            elif auswahlM== 4:
                                break#          ***********   Zurück  *********
                        else:
                            print "Teil unbekannt"

                        while not self.portas.taste:
                            self.IMP.time.sleep(.1)
                        self.portas.taste= None
                        print"zurück"
                        if teil== 1:
                            MYhoch= 210; MYstart= 20
                            Mtext= "LCD-Tests 1"
                            menu=deftest[:5]; menu.append([1,"Zurück"])
                        else:
                            MYhoch= 190; MYstart= 40
                            Mtext= "LCD-Tests 2"
                            menu=deftest[5:]; menu.append([1,"Zurück"])

                        common.menuMain(MXbreit, MXstart, MYhoch, MYstart, Rbreit, Zabstand, menu, Mtext)
                        self.lcd.display()
                        self.lcd.fill_set(False)
                        self.lcd.setcol(self.lcd.farben[1])
                        common.Mrahmen(self.lcd.farbe, auswahlM, MYstart, Zabstand, Rhoch, MXstart, Rbreit, MXbreit)
                        self.lcd.display()


                    elif Dauer < 1:#              Navigation +
#                        auswahlM= common.naviM(auswahlM, len(menu), MYstart)
                        auswahlM= common.naviM(self.lcd,auswahlM, len(menu), MYstart, Zabstand, Rhoch, MXstart, Rbreit, MXbreit)
                        self.lcd.display()
                        print "auswahlM", auswahlM
            self.IMP.time.sleep(.1)

        if 1==2:
                print "1 = LCD löschen".ljust(sbreit," "), " A = LCD ein/aus"
                print "B = LCD-Licht ein/aus"
                print "5 = Farbauswahl"
                print "F = Register auslesen"

                if eintast== "1":#      ***************   TFT löschen
                    farben=([0xff,0xff], [0x7b, 0xef], [0x39,0xe7], [0,0])
                    eintastM= raw_input("Löschfarbe (0=Weiß/ 1= Hellgrau/ 2= Dunkelgrau/ 3= Schwarz: ")
                    self.TFT_del(self.maxX, self.maxY, farben[int(eintastM)])#    ********    LCD löschen   ***

                elif eintast== "5":
                    eintastM= raw_input("Farbnummer (0 - 15):")#    Farbauswahl
                    self.setcol(self.farben[int(eintastM)])

                elif eintast== "A":#                **********   LCD ein/aus
                    eintastM= raw_input("LCD (ein= 1 / aus= 0):")
                    ports.LCDonoff(int(eintastM))
                elif eintast== "B":#                **********   Licht ein/aus
                    eintastM= raw_input("LCD-Licht (ein= 1 / aus= 0):")
                    if eintastM== "1":
#                        pwm.start(50)
                        pwm.start(self.PWM)
                    elif eintastM== "0":
                        pwm.stop()

                elif eintast== "F":   test_regread()#********   Register auslesen   ***


    def tempgrafik(self, FIL1):
        erg={}
        self.FIL1= FIL1
        def Tminmax(raumNr):
            raum= raeume[raumNr]
            zeile= erg[raum]
            Tmin= min(zeile[2])
            Tmax= max(zeile[2])
            Tdif= abs(Tmax-Tmin)
            return Tmin, Tmax, Tdif, zeile


        def anzeige(auswahl, raeume):
            Rliste= RlistT2[auswahl]

            Tdaten=[],[], [], []#  ; Tmin, Tmax, Tdif, Daten
            for R in Rliste:
                TminR, TmaxR, TdifR, zeileR= Tminmax(R)
                Tdaten[3].append(zeileR)
                Tdaten[0].append(TminR)
                Tdaten[1].append(TmaxR)
                Tdaten[2].append(TdifR)

            Tmin= min(Tdaten[0])
            Tmax= max(Tdaten[1])
            Tdif= max(Tdaten[2])

            Xmulti= 2
            Xbreit=280; Yhoch= 180
            Ymulti=Yhoch/ abs(Tmax- Tmin)
            Ystart= 220
            Xstart= 40

            if Tdif <= .1: Yteil= 1
            elif Tdif <= .5: Yteil= 2
            elif Tdif <= 1: Yteil= 5
            elif Tdif <= 2: Yteil= 5#   10
            elif Tdif <= 5: Yteil= 5#   10#  20
            elif Tdif <=10: Yteil= 10
            elif Tdif <=20: Yteil= 20
            else: Yteil= 50

            lcd.TFT_del()

            lcd.fontset("r5x8")
            lcd.setcol(lcd.farben[0])
            #   ******************   Y-Skala   *************************
            lcd.line(Xstart,Ystart, Xstart, Ystart-Yhoch+1)
            
            for yachse in range(int(Tmin*10), int(Tmax*10)+ int(Yteil/10.0)):
                if divmod(yachse, Yteil)[1]==0:
                    ywert= Ystart-(yachse/10.0-Tmin)* Ymulti

                    lcd.line(Xstart-5, int(ywert), Xstart + 2, int(ywert))
                    lcd.point(Xstart-35, int(ywert-3))
                    lcd.textR("%-04.1f" %(yachse/10.0))

            #   ******************   X-Skala   *************************
            lcd.line(Xstart,Ystart, Xstart+ Xbreit, Ystart)
            for x in range(0, Xbreit,36 ):
                lcd.setcol(lcd.farben[0])
                lcd.line(x+ Xstart, Ystart- 2, x+ Xstart, Ystart+ 5)
                lcd.point(x+ Xstart-5, Ystart+7)
                lcd.textR("%02i" % (x/12))

                lcd.setcol(lcd.farben[19])
                lcd.line(x+ Xstart, Ystart- 2, x+ Xstart, Ystart- Yhoch)



            Cliste=(1,3)
            zaehl=0
            Yadd=0

            lcd.setcol(lcd.farben[21])
            lcd.point(Xstart-35,10)#            Auswahl anzeigen
            lcd.textR("[%02d]" % auswahl)

            for R in Rliste:#                   Raumtexte anzeigen
                raum= raeume[R]
                raumR=raum.replace("_"," ")
                if chr(0xfc) in raum:
                    raumR= raumR.replace(chr(0xfc),"ü")
                if chr(0xe4) in raumR:
                    raumR= raumR.replace(chr(0xe4),"ä")

                lcd.setcol(lcd.farben[Cliste[zaehl]])
                lcd.point(Xstart, 10+ Yadd)
                lcd.textR(raumR)
                lcd.point(Xstart + 150, 10+ Yadd)
                lcd.textR("%-4.1f°C" %(Tdaten[3][zaehl][2][-1]))
                Yadd += 15
                zaehl += 1

            for GL in xrange(0, len(Rliste)):        
                xstartA= Xstart
                ystartA= Ystart
                lcd.fill_set(True)
                lcd.setcol(lcd.farben[Cliste[GL]])
                lcd.setcolBG(lcd.farben[Cliste[GL]])
                #   **********************   TemperaturLinie   ******************
                zeile= Tdaten[3][GL][2]
                temp= zeile[0]
                Gtemp= temp- Tmin
                lcd.point(Xstart, int(Ystart-(Gtemp* Ymulti+.5)))
                for x in xrange(1, len(zeile)):
                    temp= zeile[x]
                    Gtemp= temp- Tmin
                    lcd.line(Xstart+ x* Xmulti, int(Ystart-(Gtemp* Ymulti+.5)))

                temp= zeile[0]
                Stemp= temp- Tmin
                lcd.point(Xstart, int(Ystart-(Stemp* Ymulti+.5)))
                for x in xrange(1, len(zeile)):
                    temp= zeile[x]
                    Gtemp= temp- Tmin
                    lcd.line(Xstart+ 1+ x* Xmulti, int(Ystart-(Gtemp* Ymulti+.5)))

                temp= zeile[0]
                lcd.point(Xstart, int(Ystart-(Stemp* Ymulti+.5)))
                for x in xrange(1, len(zeile)):
                    temp= zeile[x]
                    Gtemp= temp- Tmin
                    lcd.line(Xstart- 1+ x* Xmulti, int(Ystart-(Gtemp* Ymulti+.5)))


                temp= zeile[0]
                lcd.point(Xstart, int(Ystart-(Stemp* Ymulti+.5)))
                for x in xrange(0, len(zeile)):
                    temp= zeile[x]
                    Gtemp= temp- Tmin
                    lcd.line(Xstart+ x* Xmulti, int(Ystart-1-(Gtemp* Ymulti+.5)))



        def daten():
            erg= {}
            erg.clear()
            self.lcd.setcolBG(self.lcd.farben[17])
            self.portas.taste= False

            #   ====================   HM-Daten abholen   =======================
            if self.FIL1.datei == "":  #   noch kein aktuelles Datum ausgewählt
                print "Datei / lang:", self.FIL1.datei, len(self.FIL1.datei)
                self.IMP.time.sleep(.5)
                MDatum= self.IMP.time.strftime("%y-%m-%d")
                print "Mdatum", MDatum###
                self.FIL1.datei = self.FIL1.DatWahl()

                ret_check = self.FIL1.checkHMdat(self.FIL1.datei, 10)
                if ret_check != 0:#         Datei nachladen
                    print"Datei " + self.FIL1.datei + " nachladen"
                    ret_load = self.FIL1.HMlog_load(self.common.IP_addr, self.FIL1.datei)
                    #-----------------------  HM_Datei in Speicher einlesen ----------------------
                    HMlzeile = FIL1.HMLoad(FIL1.datei)
                    HMzeitF = FIL1.time_DtoF(HMlzeile)
                    IMP.os.utime(FIL1.datei,(HMzeitF,HMzeitF))#### neu

                    if ret_load <=0:#       Nachladen erfolgreich
                        print"Datei", FIL1.datei, " wurde von CCU geladen"

                    else:#                  Kein Erfolg
                        print"Aktuelle Tagesdatei ", FIL1.datei, " konnte nicht geladen/ gefunden werden!"

                else:  #   Datum schon ausgewählt
                    HMlzeile = FIL1.HMLoad(FIL1.datei)


            global erg# ={}
            for x in FIL1.HM_daten:
                line= x.split(";")
                datzeit= line[0].split()
                if line[1]in erg:
                    erg[line[1]][0].append(datzeit[0])
                    erg[line[1]][1].append(datzeit[1])
                    erg[line[1]][2].append(float(line[2].replace(",",".")))
                    erg[line[1]][3].append(line[3])
                else:
                    erg[line[1]]= [datzeit[0]], [datzeit[1]], [float(line[2].replace(",","."))], [line[3]]


            raeume=[]
            for x in erg:
    #            print repr(x)
                raeume.append(x)
            return raeume




        #   =================   temptest Hauptprogramm   ========================
        
        erg={}
        RlistT2=((2,8),#            DG WohnKü / Aussen S
                 (12,11),#          DG Bad / Aussen N
                 (1, 11),#          OG Bad / Aussen N
                 (4,11),#           OG Schlaf Jü / Aussen N
                 (6, 8),#           OG Schlaf El, / Aussen S
                 (15,8),#           OG Büro Jürgen / Aussen S
                 (10,11),#          EG Gäste WC / Aussen N
                 (14,11),#           EG Küche / Aussen N
                 (0,8),#            EG Wohnzimmer / Aussen S,
                 (3,11),#           KG Waschküche / Aussen N,
                 (13,8),#           KG Hobbyraum / Aussen S,
                 (9,8),#            KG Vorratskeller / Aussen S
                 (7, 8)#            EG Garage / Aussen S
            )

        self.lcd.LCDlicht=False
        self.lcd.licht()
        auswahl= 0

        raeume= daten()
        lcd.MEM_clear()
        anzeige(auswahl, raeume)
        lcd.display()
        stop

        lmax= len(RlistT2)
        run= True

        while run:
            if portas.taste:
                Taste= portas.taste
                portas.taste= False
                Tdauer= taste.Tdauer

                if Taste== ports.T1:#        Taste 1
                    if Tdauer <= .2:#           Licht
                        print "Licht"
                        lcd.licht()
                    elif Tdauer <= 1:
                        auswahl += 1
                        if auswahl >= lmax:
                            auswahl=0
                        raeume= daten()
                        anzeige(auswahl, raeume)
                        lcd.display()
                    
                elif Taste== ports.T2:#        Taste 2
                    if Tdauer <= .2:
                        print "Abbruch"
                        lcd.LCDlicht= True
                        lcd.licht()
                        run= False
                        break
                    elif Tdauer <= 1.:
                        auswahl -= 1
                        if auswahl <0:
                            auswahl= lmax-1
                        raeume= daten()
                        anzeige(auswahl, raeume)
                        lcd.display()
            else:
                IMP.time.sleep(.1)
            
