# -*- coding: utf-8 -*-
class wetter:
    def __init__(self, FONT, LCD1, IMP, TASTE):
        print"Wetter __init__ wurde aufgerufen"

        #----------------------  Wetter-Texte definieren
        self.AktText = {1 : "Tag", 2 : "Konditionen", 3 : "Temperatur", 4 : "Regen",
                   5 : "Wind", 6 : "Luftdruck", 7 : "Luftfeuchte"}
        self.VorText = {1 : "Tag", 2 : "Konditionen", 3 : "Temp.(max)", 4 : "Temp.(min)",
                   5 : "Regenwahrsch.", 6 : "Wind", 7 : "Luftdruck",
                   8 : "Luftfeuchte"}
        self.FONT= FONT
        self.LCD1= LCD1
        self.IMP= IMP
        self.TASTE= TASTE

    def Gg_GMS(self, Mgrad):
        M_gradI = int(Mgrad)
        M_minF = (Mgrad - M_gradI) * 60
        M_minG = int(M_minF)
        M_sekF = (M_minF - M_minG) * 60
        return [M_gradI, M_minG, M_sekF]



    def loadW14dat(self, M_url, M_datName):
        self.Baum = self.IMP.URL.urlopen(M_url).read()
        self.d_out=open(M_datName,"w")
        for x in self.Baum:
            self.d_out.write(x)
        self.d_out.close()
        print"Wetterdatei wurde geladen und gespeichert"


    def webCheck(self, M_url):
        #==========================  Intenetzugang prüfen  ===========================
        if self.FONT.Name != "v5x7":
            font_ret = self.FONT.font(4)

        print "Internet-Zugang prüfen"
        print"URL: ", M_url
        Pdaten = " -c2 -w10 -i1 "
        if M_url == "www.br.de":
            Pdaten = "-c3 -w1 -i.25 -f "
        else:
            Pdaten = "-c3 -w1 -i.2 "

        self.LCD1.WYadd += 8
        self.LCD1.point(self.LCD1.WXadd, self.LCD1.WYadd)
        self.LCD1.char("ping... ")
        self.LCD1.display()
        pingErg = self.IMP.command.getstatusoutput('ping ' + Pdaten + M_url)
        self.LCD1.char(" --->")
        self.LCD1.display()

        print"Ping Exitcode:", pingErg[0]
        if pingErg[0] <> 0:
            if self.FONT.Name != "v3x6":
                self.font_ret = self.FONT.font(3)
            self.LCD1.WYadd += 8
            self.LCD1.point(self.LCD1.WXadd, self.LCD1.WYadd)
            self.LCD1.char("Kein Zugriff auf " + M_url,1)
            print"Kein Zugriff auf " + M_url + "möglich"
            self.LCD1.WYadd += 8
            self.LCD1.point(self.LCD1.WXadd, self.LCD1.WYadd)
            self.LCD1.char("Bitte Internet-Zugang prüfen!",1)
            print"Bitte Internet-Zugang prüfen!"
            self.LCD1.display()
            self.IMP.time.sleep(5)
            return pingErg[0] # 1 = kein Internetzugriff
        else:
            self.LCD1.char("   OK")
            return 0


    def checkWdat(self, W_datei,W14inter):
        if self.FONT.Name != "v5x7":
            self.font_ret = self.FONT.font(4)

        #======================= prüfen, ob Wetterdatei lokal vorhanden ===============
        WdatDa = self.IMP.FileStat.exists(W_datei)

        if WdatDa <> True:
            self.LCD1.MEM_clear()
            self.LCD1.point(self.LCD1.WXadd, self.LCD1.WYadd)
            self.LCD1.char("LAN-Zugriff!")
            self.LCD1.WYadd += 15
            self.LCD1.point(self.LCD1.WXadd, self.LCD1.WYadd)
            if self.FONT.Name != "v3x6":
                self.font_ret = self.FONT.font(3)
            self.LCD1.char("Wetterdatei nicht lokal vorhanden")
            self.LCD1.WYadd += 8
            self.LCD1.point(self.LCD1.WXadd, self.LCD1.WYadd)
            self.LCD1.char("Nachladen aus WEB erforderlich")
            self.LCD1.display()
            print"Datei muß aus WEB geladen werden"
            self.LCD1.LCD_clear()
            self.LCD1.display()
            self.IMP.time.sleep(2)
            return  1#  1 = Wetterdatei von WEB nachladen (Nicht vorhanden)

        #=======================  Datum lokaler Wetterdatei holen  ========================
        Wdat_raw = self.IMP.FileStat.getctime(W_datei)

        jetzt_raw = self.IMP.time.time()#        ======  aktuelle Zeit holen  =======
        print "Datei:", W_datei
        print "vorhanden:", WdatDa
        Tdif = jetzt_raw - Wdat_raw#    ======  Zeitdiffrenz bilden  ======

        if abs(Tdif/3600) > int(W14inter):
            addX = 0
            self.LCD1.MEM_clear()
            self.LCD1.LCD_clear()

            self.LCD1.WYadd = 8
            self.LCD1.point(self.LCD1.WXadd, self.LCD1.WYadd)
            self.LCD1.point(addX,8)
            if self.FONT.Name != "v5x7":
                self.font_ret = self.FONT.font(4)
            self.LCD1.char("LAN-Zugriff!")
            self.LCD1.WYadd += 15
            self.LCD1.point(self.LCD1.WXadd, self.LCD1.WYadd)
            if self.FONT.Name != "v3x6":
                self.font_ret = self.FONT.font(3)
            print"Wetterdatei älter als %2d Stunden"% abs(Tdif/3600)
            self.LCD1.char("Wetterdatei älter als %2d Stunden"% abs(Tdif/3600))
            self.LCD1.WYadd += 8
            self.LCD1.point(self.LCD1.WXadd, self.LCD1.WYadd)
            self.LCD1.char("Nachladen aus WEB erforderlich")
            self.LCD1.display()

            print"Datei muß aus dem WEB geladen werden"
            print "Differenz:",abs(Tdif/3600)
            print"Wetterdatei älter als "+ str(W14inter)+" Stunden."
            print "Datei muß nachgeladen werden!"
            return 2#  2 = Wetterdatei von WEB nachladen (Alter > [W14inter] Std.)
        else:
            return 0#  0 = normales Ende


    def W5_kopf(self,daten):
        if self.FONT.Name != "v5x7":
            self.font_ret = self.FONT.font(4)
        Xadd = 0
        Yadd = 6
        self.LCD1.MEM_clear()

#        self.LCD1.box(0,0,160,8,1)
        self.LCD1.box(0,0,self.LCD1.maxX,8,1)
        self.LCD1.pen(-1)
        self.LCD1.point(Xadd + 5,Yadd)#    Prognose-Ort
        self.LCD1.char(daten[0])
        Yadd += 10
        self.LCD1.point(Xadd, Yadd)#       Prognose-Wochentag
        self.LCD1.char(daten[1]+", ")
#        Yadd += 8
#        self.LCD1.point(Xadd,Yadd)#         Prognose-Datum
        self.LCD1.char(daten[2])
#        self.LCD1.point(Xadd + 75, Yadd)#     Prognose-Zeit
        self.LCD1.char(daten[3])


    def W5_Stext(self, texte, X_add, Y_add):
#        if self.FONT.Name != "v3x6":
        if self.FONT.Name != "v5x7":
            self.font_ret = self.FONT.font(3)
        Xadd = 5
        for x in range(0,len(texte)):
            Wtext = texte[x]
            self.LCD1.point(X_add, Y_add)
            self.LCD1.char(Wtext)
            Y_add += 10#8


    def W5_akt(self,zeile, X_add):
#        if self.FONT.Name != "v3x6":
        if self.FONT.Name != "v5x7":
            self.font_ret = self.FONT.font(3)
        Yadd = 45
        Sorder = [3, 4, 5, 6, 7, 2]
        self.LCD1.point(X_add, Yadd - 8)
        self.LCD1.char(zeile[1])
        for x in range(0,len(Sorder)):
#            self.LCD1.point(X_add,Yadd + 8)
            self.LCD1.point(X_add,Yadd + 10)
            self.LCD1.char(zeile[Sorder[x]])
            Yadd += 10# 8


    def W5_vor(self, zeile, X_add, Y_add, Zmax):
        if self.FONT.Name != "v3x6":
            self.font_ret = self.FONT.font(3)
        Yadd_sic = Y_add
        Sbreit = 9# 6
        Xbreit = 38#    26
        Sorder = [1, 3, 4, 5, 6, 7, 8, 2]
###        self.LCD1.point(X_add, Y_add - 8)

        for x in zeile:
            if x > Zmax:
                print "Spaltenanzahl > Zmax:", x, Zmax
                break
            else:
                Y_add = Yadd_sic
#                Y_add = 10
                Ezeile = zeile[x]
                for y in range(0, len(Ezeile)):
                    wert = Ezeile[Sorder[y]].split(" ")
                    Ztext = wert[0]

                    if y == 4:      #############   Wind   ###########
                        Ztext += " " + wert[2]

                    elif y == 7:    #############  Konditionen  ######
                        Ztext = wert[len(wert)-1]

                    uml = self.LCD1.Szei(Ztext)   ##########  Sonderzeichen in Text vorhanden ?  ######
#                    self.LCD1.point(X_add + x * Xbreit,Y_add - 8)
                    self.LCD1.point(X_add+ 3 + x * Xbreit,Y_add - 9)
                    self.LCD1.char(Ztext.rjust(Sbreit + uml," ")[:Sbreit+ uml])
                    Y_add += 10#    8


    def vorher_5(self):
        if self.FONT.Name != "v3x6":
            font_ret = self.FONT.font(3)

        self.LCD1.WXadd = 0
        self.LCD1.WYadd = 8
        print"Start"

        # Lokaler Wetter Dateiname
        WdatName = "./wetter_br.xml"
        # Adresse der Wetter XML-Datei
        M_URL="http://www.br.de/wetter/action/5_tage_prognose.do?" + self.LCD1.config["W05Code"] + "&pda=true"
        checkWdat_ret = self.checkWdat(WdatName, 1)# stündlich

        if checkWdat_ret > 0:#       Datei aus Internet laden
            print"Wetterdaten aus Internet nachladen"
            self.LCD1.WYadd += 10
            self.LCD1.point(self.LCD1.WXadd, self.LCD1.WYadd)
            self.LCD1.char("WEB-Zugriff prüfen")

            webCheck_ret = self.webCheck('www.br.de')
            print"Rückbagewert von 'www.br.de' check:", webCheck_ret
            self.LCD1.display()

            if webCheck_ret >0 :#           Kein Internetzugang
                self.LCD1.WYadd += 8
                if self.FONT.Name != "v5x7":
                    self.font_ret = self.FONT.font(4)
                self.LCD1.point(self.LCD1.WXadd, self.LCD1.WYadd)
                self.LCD1.char("Kein WEB-Zugriff möglich")
                self.LCD1.WYadd += 8
                if self.FONT.Name != "v3x6":
                    self.font_ret = self.FONT.font(3)
                self.LCD1.point(self.LCD1.WXadd, self.LCD1.WYadd)
                self.LCD1.char("WEB-Zugang prüfen! Keine Verbindung",1)

                print"Interetzugang prüfen. Keine Verbindeung möglich"
                print"Die bereits vorhandenen alten Daten werden verwendet"
                self.LCD1.display()
                self.IMP.time.sleep(3)
                exit
            else:
                self.LCD1.WYadd += 8
                if self.FONT.Name != "v3x6":
                    self.font_ret = self.FONT.font(3)

                self.LCD1.point(self.LCD1.WXadd, self.LCD1.WYadd)
                self.LCD1.char("Datei nachladen .....")
                self.LCD1.display()
                print"Datei nachladen: --->"
                self.loadW14dat(M_URL, WdatName)
                print"Nachladen erl."
                if self.FONT.Name != "v5x7":
                    self.font_ret = self.FONT.font(4)

                self.LCD1.char("  Erledigt")
                self.LCD1.display()
                self.IMP.time.sleep(1)

        Baum=""
        d_in=open("./wetter_br.xml","r")
        for Zline in d_in:
            Baum += (Zline)
        d_in.close()

        LaLoDat={}
        FortDat={}
        Datenfeld={}
        masterLines=[]

        all_lines= Baum.splitlines()
        anzeigen=False

        print
        print "Wetterdaten vom 'Bayerischen Rundfunk'"
        print M_URL
        print

        #======================  relevanten zeilen aus www.datei herausfiltern ========
        MasterLines=[]
        for x in all_lines:
            zeile=x.strip()
            if len(zeile):

#                if "<h3>" in zeile:#                ######   Prognose-Ort   #####
                if "Wetter -" in zeile:#                ######   Prognose-Ort   #####   NEU 28.06.2017
                    anzeigen=True
                if "<tbody>" in zeile:#                ######   Prognose-Werte   #####
                    anzeigen=True
                if '<div class="TimeStamp">' in zeile:#   ######   Prognose-Datum   #####
                    anzeigen=True

                if anzeigen:
                    if "h3" not in zeile:
                        if zeile.find(">")+1 < len(zeile): 
                            MasterLines.append(zeile)
                    if "</h3>" in zeile:
                        anzeigen=False
                    if "</table>" in zeile:
                        anzeigen=False
                    if "Uhr</span></p>" in zeile:
                        anzeigen=False

        Daten = {}
        Szeilen = {}
        Dzeile = {}
        Szaehler = 0
        STag=0
#        print"Master"
#        for x in MasterLines:
#            print x, len(x)
#        stop

        #############  Zeilen zerlegen und in 'M_W5kopf' / 'Daten' ablegen  #########
        self.Xadd = 10
        self.Yadd = 5
        self.LCD1.MEM_clear()
        self.LCD1.pen(3)

        M_W5kopf =[]
        for x in MasterLines:
            if "<p>Prog" in x:#         Prognose-Datum
                Szaehler=2
                Pzeile = x.split(" ")
                M_W5kopf.append("von " + Pzeile[2])
                M_W5kopf.append(Pzeile[3] + " /")
                continue

            if Szaehler == 2:#         Prognose-Uhrzeit
                Szaehler=0
                Pfind_B= x.find(">")
                Pfind_E= x.find("<",Pfind_B)
                Pzeit=x[Pfind_B+1:Pfind_E]
                M_W5kopf.append(Pzeit)
                continue

            if Szaehler==1:#            Prognose-Ort
                Szaehler = 0
                M_W5kopf.append("Wetterprognose für: " + x)
                print"Ort", x
                continue

            if "Wetter -" in x:
                Szaehler = 1

                continue

            if "<strong>" in x:
                Tzaehler = 0
                Zindex=x[x.find("g>") + 2:x.find("</")]
                Dzeile[Tzaehler + 1] = Zindex
                continue
            else:
                wert=x[x.find(">") + 1:x.find("</")]
                Tzaehler += 1

                if Zindex == "Aktuell":
                    Sindex = self.AktText[Tzaehler]
                else:
                    Sindex = self.VorText[Tzaehler]

                if wert== "Kein Wetterzustand vorhanden":
                    wert= "Nicht vorhanden"
                Dzeile[Tzaehler + 1] = wert

                if (Tzaehler >=6 and Zindex =="Aktuell"):
                    Daten[Zindex]=Dzeile
                    Dzeile={}
                    continue
                if (Tzaehler >=7 and Zindex !="Aktuell"):
                    STag += 1
                    Szeilen[STag] = Dzeile
                    Dzeile={}
                    Daten["Vorhersagen"]=Szeilen

        ############## Werte aus 'Daten' abrufen und ausgeben ############

        W_texte = ["Temp.", "Temp.", "Nieder", "Wind", "Druck","Feuchte", "Kondit."]
        AktPro = True
        Mende = False
        self.TASTE.taste = self.LCD1.T1
        self.TASTE.Tdauer = .25

        while not Mende:
            if self.TASTE.taste:
                TD= self.TASTE.Tdauer
                print "Taste >> ",
                print  "Dauer: %6.3f" % self.TASTE.Tdauer,

                if self.TASTE.taste== self.LCD1.T1:
                    if TD > .05:
                        if TD < .15:
                            print "kurz (LCD-Licht)"
                            self.LCD1.lichtAN = not self.LCD1.lichtAN
                            self.LCD1.Licht(self.LCD1.lichtAN)  # LCD-Beleuchtung umschalten
                        elif TD < .9:
                            print "MITTEL"
                            #######   Tastenlänge MITTEL = Hauptprogramm ausfuhren   #############
                            if AktPro:
                            ############################   Aktuelle Werte anzeige   #########################
                                Sbreit = 8
                                Zbreit = 4
                                self.Xadd = 30
                                self.Yadd = 45
                                Sbreit
                                Spix= Sbreit * Zbreit

                                self.W5_kopf(M_W5kopf)#         ##########  5Tage-Wetter Kopf anzeigen
#                                self.LCD1.line(self.Xadd, self.Yadd -6, self.Xadd + 100, self.Yadd -6)
#                                self.LCD1.line(self.Xadd + 30, self.Yadd -13, self.Xadd + 30, 100)
                                self.LCD1.line(self.Xadd, self.Yadd -6, self.Xadd + 170, self.Yadd -6)
#                                self.LCD1.line(self.Xadd + 50, self.Yadd -13, self.Xadd + 50, 100)
                                self.LCD1.line(self.Xadd + 50, self.Yadd -16, self.Xadd + 50, 110)
                                self.LCD1.pen(3)
                                self.W5_Stext(W_texte, self.Xadd, self.Yadd)#     #########   Zeilenbeschriftung   ########
                                Dzeile = Daten["Aktuell"]#      ##########   Aktuelle Werte anzeigen   #####
#                                self.W5_akt(Dzeile, self.Xadd + 40)
                                self.W5_akt(Dzeile, self.Xadd + 60)
                            else:
                            ############################   Prognose Werte anzeige   #########################
                                self.Xadd = 7
                                self.Yadd = 45
                                self.W5_kopf(M_W5kopf)#         ##########  5Tage-Wetter Kopf anzeigen
                                self.LCD1.pen(2)
#                                self.LCD1.line(0, self.Yadd -5, 160, self.Yadd -5)
                                self.LCD1.line(0, self.Yadd -5, self.LCD1.maxX, self.Yadd -5)

                                Xmulti= 38# 26
                                Xstart= 45# 31
                                for x in range(0,5):
#                                    self.LCD1.line(31 + x * 26, self.Yadd -13, 31 + x * 26, 100)
                                    self.LCD1.line(Xstart+1 + x * Xmulti, self.Yadd -13, Xstart+1 + x * Xmulti, 110)
                                self.Yadd += 1
                                self.LCD1.pen(3)
                                self.W5_Stext(W_texte, 0, self.Yadd)#     #########   Zeilenbeschriftung   ########
                                Dzeile = Daten["Vorhersagen"]
                                self.W5_vor(Dzeile, self.Xadd, self.Yadd, 5)#           ##########   Prognosewerte anzeigen   ########
                            AktPro = not AktPro

                            self.LCD1.LCD_clear()
                            self.LCD1.display()
                        else:
                            print "LANG"
                            Mende = True
                    else:
                        print
                    self.TASTE.taste=False
                    self.LCD1.display()

                if self.TASTE.taste== self.LCD1.T2 and TD >= .05:
                    print ">",
                    if TD >= 0.75:
                        print ">"
                        print"\t==> Hardcopy"
                        GHC1.Hcopy(LCD1, "OAL_Wetter_5Tage", 4, 3)

                self.TASTE.taste= False                        

            self.IMP.time.sleep(.1)

        self.LCD1.LCD_clear()
        self.LCD1.Licht(0)
        print "Ende"


    def W14kopf(self, kopf, Ypos):
        if self.FONT.Name != "v3x6":
            font_ret = self.FONT.font(3)

#        for x in ("Titel", "Ort", "Geo", "Zeitraum"):
        self.LCD1.point(self.Xadd, Ypos)
        self.LCD1.char(kopf["Titel"])
#            self.LCD1.char(kopf[x])
        Ypos += 9#  7

        self.LCD1.point(self.Xadd, Ypos)
        self.LCD1.char(kopf["Geo"])
        Ypos += 9#  7

        self.LCD1.point(self.Xadd, Ypos)
        self.LCD1.char("für "+ kopf["Ort"]+ " - "+kopf["Zeitraum"])
        Ypos += 9# 7



    def W14temp(self, hochY,breitX, LstartX, LstartY, Xindex):
        if self.FONT.Name != "v3x6":
            font_ret = self.FONT.font(3)
    #================================   Grafik zeichnen   =========================

    #    #########  x-Skakla/ Beschriftung  ###################################
    #    W14achse_X(breitX, LstartX, LstartY, Xindex, tagGes,datGes)
        tempDif = self.Tmax - self.Tmin

        #   Y-Teilung berechnen (Autowert)
        Yteil = int(hochY / float(tempDif))

        Trest = hochY / Yteil -tempDif#     ======= unbenutzten Grafikbereich =======
        TminM = self.Tmin-int(Trest/2.0 + .5)#    ============  vertikal ausmitteln   ========

        #         Y-Skala zeichnen (Grafik)
        self.LCD1.line(int(LstartX), int(LstartY), int(LstartX), int(LstartY-hochY ))
        for y in range(LstartY, LstartY -hochY - 1, Yteil * -1):
            tempS = (LstartY - y)/ Yteil + TminM
            if int(tempS/5.0) == tempS/5.0:
                Ylang = 3
                self.LCD1.pen(2)
                self.LCD1.line(int(LstartX - Ylang), int(y) , int(LstartX + breitX), int(y))
                self.LCD1.pen(3)
                self.LCD1.point(LstartX - 15, y + 2)
                self.LCD1.char(str(tempS).rjust(3, " "))
            else:
                Ylang = 1

            self.LCD1.line(int(LstartX - Ylang), int(y) , int(LstartX + Ylang), int(y))

        Xmulti= 14
        for x in range(0, len(self.minGes)):
            Gmin = int(self.minGes[x])
            Gmax = int(self.maxGes[x])
            Gdif = Gmin - Gmax
            tempS = (LstartY)/ Yteil + TminM


#            Xstart = LstartX + x * 10 + 5 -2
#            Xende = LstartX + x * 10 + 5 + 3
            Xstart = LstartX + x * Xmulti + 6 -2
            Xende = LstartX + x * Xmulti + 6 + 5#   3
            Ystart = LstartY - (Gmin- TminM) * Yteil
            Yende = LstartY -(Gmax- TminM) * Yteil

            self.LCD1.box(Xstart, Ystart, Xende, Yende, 1)

    def W14achse_X(self, breitX, LstartX, LstartY, Xindex):
        if self.FONT.Name != "v3x6":
            font_ret = self.FONT.font(3)

        #       X-Skala zeichnen (Grafik)
        Xmulti= 14
        self.LCD1.line(LstartX, LstartY, LstartX + breitX, LstartY)
        for x in xrange(0, len(self.tagGes)):
            self.LCD1.line(LstartX+ x* Xmulti, LstartY - 1, LstartX+ x* Xmulti, LstartY + 3)
            self.LCD1.point (LstartX+ x * Xmulti+ 4, LstartY + 6)
            self.LCD1.char(self.tagGes[x])#         Wochentag
            self.LCD1.point (LstartX+ x * Xmulti+ 4, LstartY + 12)
            M_dat = self.datGes[x].split(".")[0]
            self.LCD1.char(M_dat.rjust(2,"0"))#     Datum (Tag)
            Xindex += 1

    def vorher_14(self):#   wetter14():
        if self.FONT.Name != "v3x6":
            font_ret = self.FONT.font(3)

        self.LCD1.WXadd = 0
        self.LCD1.WYadd = 8
        self.Xadd= None
        self.Yadd= None
        self.Ypos= None

        print "Wetterbericht 14 Tage von Wetter.com"
        print"Start"

        # Lokaler Wetter Dateiname
        WdatName = "./langwetter_wetterCom.xml"
        # Adresse der Wetter XML-Datei
        URL = "http://www.wetter.com/wetter_aktuell/wettervorhersage/16_tagesvorhersage/?id=" + self.LCD1.config["W14Code"]
        checkWdat_ret = self.checkWdat(WdatName, self.LCD1.config["W14inter"])
        print "Rückgabewert aus Prüfroutine:", checkWdat_ret
        if checkWdat_ret > 0:#       Datei aus Internet laden
            print"Wetterdaten aus Internet nachladen"
            self.LCD1.WYadd += 10
            self.LCD1.point(self.LCD1.WXadd, self.LCD1.WYadd)
            self.LCD1.char("Prüfung, ob WEB-Zugriff möglich")
            print"Wetterdaten aus Internet nachladen"
            self.LCD1.display()

            webCheck_ret = self.webCheck('www.wetter.com')
            if webCheck_ret >0 :#           Kein Internetzugang

                self.LCD1.WYadd += 8
                self.LCD1.point(self.LCD1.WXadd, self.LCD1.WYadd)
                if self.FONT.Name != "v5x7":
                    font_ret = self.FONT.font(4)
                self.LCD1.char("Kein WEB-Zugriff möglich")
                self.LCD1.display()
                self.LCD1.WYadd += 8
                self.LCD1.point(self.LCD1.WXadd, self.LCD1.WYadd)
                self.LCD1.char("WEB-Zugang prüfen! Keine Verbindung",1)

                print"Interetzugang prüfen. Keine Verbindeung möglich"
                print"Die bereits vorhandenen alten Daten werden verwendet"
                self.LCD1.display()
                self.IMP.time.sleep(3)
                exit
            else:
                self.LCD1.WYadd += 8
                self.LCD1.point(self.LCD1.WXadd, self.LCD1.WYadd)
                if self.FONT.Name != "v3x6":
                    font_ret = self.FONT.font(3)

                self.LCD1.char("Datei nachladen .....")
                self.LCD1.display()
                print"Datei nachladen: --->"
                self.loadW14dat(URL, WdatName)
                if self.FONT.Name != "v5x7":
                    font_ret = self.FONT.font(4)
                print"Nachladen erl."
                self.LCD1.char("  Erledigt")
                self.LCD1.display()
                self.IMP.time.sleep(1)

        Baum=""
        d_in=open(WdatName,"r")
        for datLine in d_in:
            Baum += (datLine)
        d_in.close()

        all_lines= Baum.splitlines()
        del Baum#   Variable löschen
        anzeigen= False
        print
        print "Wetterdaten von 'Wetter.com'"
        print URL

        MasterLines=[]
        for x in all_lines:#            Start-Schlüsselwörter finden in XML-Datei
            zeile=x.strip()
            if len(zeile):
                if "<title>" in zeile:
                    anzeigen=True
                elif ':latitude' in zeile:
                    anzeigen=True
                elif ':longitude' in zeile:
                    anzeigen=True
                elif "var precipitation = " in zeile:
                    anzeigen=True
                elif 'var temperatureMax = ' in zeile:
                    anzeigen = True
                elif 'var temperatureMin = ' in zeile:
                    anzeigen = True
                elif 'var times = ' in zeile:
                    anzeigen = True

                if anzeigen:#               Stop-Schlüsselwörter finden
                    if "h3" not in zeile:
                        if zeile.find(">")+1 <= len(zeile): 
                            MasterLines.append(zeile)
                    if "<title>" in zeile:
                        anzeigen=False
                    if ':latitude' in zeile:
                        anzeigen=False
                    if ':longitude' in zeile:
                        anzeigen=False
                    if "var temperatureMin = " in zeile:
                       anzeigen=False
                    if "var temperatureMax = " in zeile:
                        anzeigen = False
                    if "var precipitation = " in zeile:
                        anzeigen = False
                    if 'var times = ' in zeile:
                        anzeigen = False

        del all_lines#          Variable löschen
        #############  Zeilen zerlegen und speichern  #########
        Szaehler = 0
        STag=0

        self.minGes = []#            Sammler Minimum Werte
        self.maxGes = []#            Sammler Maximum Werte
        self.tagGes = []#            Sammler Wochentag
        self.datGes = []#            Sammler Datum
        self.regGes = []#            Sammler Regen Werte

        self.Xadd = 5
        self.Yadd = 4
        self.Tmin = 99
        self.Tmax = -99
        self.Rmax = 0.0

        self.LCD1.MEM_clear()

        ########################   Datum lokale Wetter14-Datei   ##################
        Tkopf = {}
        Fdat = self.IMP.time.localtime(self.IMP.FileStat.getctime(WdatName))
        DtimeS = str(Fdat[2]).rjust(2,"0") + "." + str(Fdat[1]).rjust(2,"0") + \
                 "." +str(Fdat[0]) + "/" + \
                 str(Fdat[3]).rjust(2,"0") + ":" + str(Fdat[4]).rjust(2,"0")
        Tkopf["Titel"] = "Wetterprognose 14 Tage " + DtimeS

        langbreit= 0
        for x in MasterLines:
            if "<title>" in x:#             ########   Prognose-Ort   ##########
                zeile = x.split(":")
                Dzeile={}
                erg= zeile[0].split("Wetter ")
                Tkopf["Ort"]= erg[1]
                continue

            elif ':longitude' in x:#        ##############  Geogr. Länge  ###########
                zeile = x.split("=")
                zeileG = zeile[2].split('"')
                Dzeile={}

                L_Lang = zeileG[1]
                Llang = self.Gg_GMS(float(L_Lang))
                Lzu = L_Lang > 0 and "O" or "W"
                langbreit += 1

                TkopfL= str(Llang[0])+"°" + str(Llang[1]) + \
                     "'" + str(int((Llang[2]*10)+.5)/10.0) +'"'+ Lzu

                if langbreit > 1:
                    Tkopf["Geo"]= "Breit:" + TkopfB + "   Lang:" + TkopfL
                    del langbreit
                continue


            elif ':latitude' in x:#        ##############  Geogr. Breite  ###########
                zeile = x.split("=")
                zeileG = zeile[2].split('"')
                Dzeile={}

                L_Breit = zeileG[1]
                Lbreit = self.Gg_GMS(float(L_Breit))
                Bzu = L_Breit > 0 and "N" or "S"

                langbreit += 1

                TkopfB= str(Lbreit[0])+"°" + str(Lbreit[1]) + \
                     "'" + str(int((Lbreit[2]*10)+.5)/10.0) +'"'+ Bzu

                if langbreit > 1:
                    Tkopf["Geo"]= "Breit:" + TkopfB + "   Lang:" + TkopfL
                    del langbreit

                continue


            #==============================  Temperaturen  =======================
            elif "temperatureMin" in x:#       ###########  Minimum-Werte  ##########
                werte = x[x.find("[") + 1 : x.find("]")]

                for w in werte.split(","):
                    if w != "null":
                        self.minGes.append(int(w))

                self.Tmin= min(self.minGes)
                continue

            elif "temperatureMax" in x:#       ###########  Maximum-Werte  ##########
                werte = x[x.find("[") + 1 : x.find("]")]
                print "werte:", werte
                for w in werte.split(","):
                    if w != "null":
                        self.maxGes.append(int(w))

                self.Tmax = max(self.maxGes)
                continue


            elif "times" in x:#           ############  Prognose-Datum/ Tag  ########
                self.zeile=x[x.find("[")+1: x.find("]")]
                self.gruppe= self.zeile.split(",")
                for w in self.gruppe:
                    werte= w.strip('"').split(" ")
                    self.datGes.append(werte[1])#       Datum
                    self.tagGes.append(werte[0])#       Wochentag
                continue


            #==============================  Regenwerte  =======================
            elif "precipitation" in x:#     Regen-Wert
                zeile = x[x.find("[")+ 1: x.find("]")]
                werte = zeile.split(",")
                for w in werte:
                    self.regGes.append(float(w))

                self.Rmax= max(self.regGes)
                continue

        ############## Werte abrufen und ausgeben ############
        Wdat_raw = self.IMP.FileStat.getctime(WdatName)
        Dtime = self.IMP.time.localtime(Wdat_raw)
        DtimeS =str(Dtime[2]) +"."+ str(Dtime[1])+"/" + \
                 str(Dtime[3]).rjust(2, "0") +":"+ str(Dtime[4]).rjust(2, "0")
        DtimeS ="%02d.%02d. / %02d:%02d"% (Dtime[2],Dtime[1], Dtime[3],Dtime[4])
        print "Datum lokale Wetterdatei:",DtimeS

        Pzraum = ""
        for x in (0,15):
            try:
                werte = self.datGes[x]
            except:
                wert="-"
            Pzraum += werte
            if x == 0:
                Pzraum += " - "
        Tkopf["Zeitraum"] = "Zeitraum: " + Pzraum

        W14part = False
        Mende = False
        self.TASTE.Tstart = self.IMP.time.time() - .2
        self.TASTE.taste = self.LCD1.T1
        self.TASTE.Tdauer = .25

        while not Mende:
            if self.TASTE.taste:
                TD= self.TASTE.Tdauer
                print "Taste >> ",
                print  "Dauer: %6.3f" % TD,

                if self.TASTE.taste== self.LCD1.T1:
                    if TD > .9:
                        print "LANG"
                        Mende = True
                        break
                    elif TD > .2:
                        print"Mittel"
                        hochY = 84# 64
                        breitX = 224#   140
                        LstartX = 15
                        LstartY = 111#  91
                        Xindex = 0

                        self.LCD1.MEM_clear()
                        if not W14part:
                            print"Wetter14 - Temperaturen"
                            self.W14kopf(Tkopf, self.Yadd)#            Kopf darstellen
                            #                    x-Skakla/ Beschriftung
                            self.W14achse_X(breitX, LstartX, LstartY, Xindex)
                            #                   Temperatur-Grafik darstellen
                            self.W14temp(hochY,breitX,LstartX,LstartY,Xindex)

#                            self.LCD1.point(0,99)
                            self.LCD1.pen(2)
                            self.LCD1.point(0,119)
                            self.LCD1.char("[°C]")
                            self.LCD1.pen(3)
                            W14part = not W14part
                        else:
                            print "Wetter14 - Regenmengen"
                            X_add = 20
                            Y_add = 47
                            self.W14kopf(Tkopf, self.Yadd)#            Kopf darstellen

                            Xmal = breitX / len(self.regGes)
                            Ymal = (hochY -10) / self.Rmax
                            Yanz = (self.Rmax + 5)/5
                            Bbreit = 7

                            if self.FONT.Name != "v3x6":
                                font_ret = self.FONT.font(3)
                            print"Kopf"
                            print "regen", self.regGes
                            print"Xmal", Xmal
                            print"Ymal", Ymal
                            print"Yanz", Yanz
                            print"LstartY", LstartY
                            print"Rmax", self.Rmax
                            print "range:", 0,int(Yanz)+1

                            if 1==2:############   nur zum Test   ############
###                            for x in range(0,int(Yanz)+1):#         Y-Skala/ Beschriftung
                                print"x", x
                                startLY = LstartY - ( x * 5 * Ymal)
#                                self.LCD1.line(LstartX-2, startLY, LstartX+1, startLY)
                                print"Line",(int(LstartX-2), int(startLY), int(LstartX+ 1), int(startLY))
                                self.LCD1.line(int(LstartX-2), int(startLY), int(LstartX+ 1), int(startLY))
                                self.LCD1.point(int(LstartX) -2 -8, int(startLY) +2)
                                self.LCD1.char("%2d"% (x * 5))
                                self.LCD1.pen(1)
                                self.LCD1.line(int(LstartX+ 3), int(startLY), int(LstartX+ 1+ breitX), int(startLY))
                                self.LCD1.pen(3)
                            print"regen", self.regGes
#                            stop

                            for x in range(0, len(self.regGes)):#        Balken zeichnen
                                Fwert = float(self.regGes[x])
                                wert = format(Fwert + .05, ".0f")
                                if wert >"99":
                                    wert = "++"
                                Xmitte = int(int(LstartX)+2  + x*Xmal + Bbreit/2.0+.5)
                                Xdiff = len(wert) * 3.0 / 2.0
                                Xstart = int(Xmitte - Xdiff +.5)-1
                                self.LCD1.point(Xstart+3, int(LstartY - (Fwert*Ymal + 2)))
                                self.LCD1.pen(-1)
                                self.LCD1.char(wert)
                                self.LCD1.box(int(LstartX) +4 + x*Xmal, LstartY, int(LstartX) +4 + Bbreit + x*Xmal, LstartY - (Fwert*Ymal),1)
                            #                                 x-Skala/ Beschriftung
                            self.LCD1.pen(3)
                            self.W14achse_X(breitX, LstartX, LstartY, Xindex)
                            self.LCD1.line(LstartX, LstartY, LstartX, LstartY-hochY)
#                            self.LCD1.point(0,99)
                            self.LCD1.pen(2)
                            self.LCD1.point(0,121)
                            self.LCD1.char("[mm]")
                            self.LCD1.pen(3)
                            print
                            W14part = not W14part

                        self.LCD1.LCD_clear()
                        self.LCD1.display()
                    else:
                        print "kurz (LCD-Licht)"
                        self.LCD1.lichtAN = not self.LCD1.lichtAN
                        self.LCD1.Licht(self.LCD1.lichtAN)  # LCD-Beleuchtung umschalten


                elif self.TASTE.taste== self.LCD1.T2 and TD >= .05:
                    print ">",
                    if TD >= 0.75:
                        print ">"
                        print"\t==> Hardcopy"
                        GHC1.Hcopy(LCD1, "OAL_Wetter_14Tage", 3, 3)

                self.TASTE.taste= False
                
            else:
                self.IMP.time.sleep(.1)

        self.LCD1.LCD_clear()
        self.LCD1.Licht(0)
        print"Ende"
