#!/usr/bin/python
# -*- coding: utf-8 -*-

#*************   Klassen importieren   **********************

import HM_import_20170709_2000 as imp
import HM_font_20170709_2000 as font
import HM_taste_20170709_2000 as taste
import HM_lcd_20170709_2000 as lcd
import BR_wetter_20170711_1500 as wetter



###########################   Hauptprogramm   ########################

#       ***  GPIO-Ports definieren   ****** ===== BCM =====
LCDlicht=24#    Hintergrundbeleuchtung
RS = 25#        Befehl/ Daten
T1= 4#          Taste 1
T2= 18#         Taste 2

#       ***  Klassen definieren   ***
IMP=imp.Import()
FONT= font.font()
TASTE= taste.taste(IMP)
#   moeglich=("EA DOGXL240W-7", "EA DOGL128W-6", "EA DOGXL122X-2")
LCD1= lcd.LCD("EA DOGXL240", LCDlicht, RS, T1, T2, "BCM", IMP, TASTE, FONT)
wetter= wetter.wetter(FONT, LCD1, IMP, TASTE)


print "Initiiert:",LCD1.LCDtyp
print "GPIO-Pins:",LCD1.GPIO_pins()

erg= LCD1.LCDtyp
if erg != "-1":
    print "GPIO + SPI erfolgreich initialisiert"
else:
    print"LCD konnte nicht initialisiert werden"
    quit

Lret= LCD1.Licht(LCD1.lichtAN)
TASTE.taste = tasteI = False

#==============================   Auswählbare Prozeduren   =========================

def LCD_test():#             ****************   Test-Grafik   *******************
    LCD1.pen(3)
    LCD1.box(0,0,8,8,1)
    LCD1.pen(0)
    LCD1.box(2,2,6,6,1)
    LCD1.pen(3)
    LCD1.circle(50,50,18,1)
    LCD1.line(70,30,120,50)
    LCD1.line(0,20,20,0)
    LCD1.display()


def LCD_fertig():
    global LCD1, IMP
    LCD1.LCD_clear()
    IMP.time.sleep(.1)
    LCD1.LCD_ende()
    IMP.time.sleep(5)
    LCD1.Licht(0)
    LCD1.LCD_close()
    print"ENDE"



print"""\n\nDie 5-tägige Wettervorhersage des BR kann nun mit der Prozedur
'wetter.vorher_5()' aufgerufen werden.
\nDie 16-tägige wetter.com Vorhersage ruft man mit 'wetter.vorher_14()' auf.\n
Taste 1 < 0,25 Sekunden gedrückt, schaltet das Hinergrundlicht ein/aus
Wird die Taste länger gedrück, wird die Folgegrafik angezeigt.
Ein Tastendruck länger als 1 Sek. beendet die Anzeigeroutine.\n

Danach können die LCD Befehle normal verwendet werden.
Zur tatsächlichen Anzeige am LCD den Befehl 'LCD1.display() nicht vergessen!!!
Hintergrundbeleuchtung mit LCD1.Licht(0|1) ein-, bzw. ausschalten.

Eine grobe Übersicht der Möglichkeiten kann mit 'dir(LCD1) aufgerufen werden.
Dabei ist jedoch zu bechten, daß einige Nemen nur als intene Variablen
verwendet werden und keine ausführbaren Befehle oder Prozeduren sind.
\nEin Test des LCD kann mit 'LCD_test()' aufgerufen werden.

Am Ende der Tests werden die GPIO-Ports mit der Prozedur 'LCD_fertig()'
freigegeben."""
