#!/usr/bin/python
# -*- coding: utf-8 -*-

#*************   Klassen importieren   **********************
import TFT_lcd_20170710_1000 as lcd
import TFT_ports_20170710_1000 as ports
import TFT_taste_20170710_1000 as taste
import TFT_import_20170710_1000 as imp
import ZeichensaetzeLCD as font


def lcd_test():
    lcd.fontset('r5x8')
    lcd.point(100,30)
    lcd.textR("Rastertext: '"+ lcd.zname+ "'")

    lcd.fontset('r10x14')
    lcd.point(20,90)
    lcd.textR("Rastertext: '"+ lcd.zname+ "'")

    lcd.setcol(lcd.farben[1])
    lcd.fontset('r12x18')
    lcd.point(15,195)
    lcd.textR("Rastertext: '"+ lcd.zname+ "'")

    lcd.setcol(lcd.farben[6])
    lcd.fontset('v5x7')
    lcd.point(100,60)
    lcd.textV("Vektortext: '"+ lcd.zname+ "'")

    lcd.fill_set(True)
    for x in range (100,240, 40):
        lcd.setcolBG(lcd.farben[int((x-100)/9)])
        lcd.circle(x,150,35)

    lcd.setcolBG(lcd.farben[7])
    for x in range (100,240, 40):
        lcd.circle(x,150,17)

    for x in range(0,32):#      Graustufen
        lcd.setcol([x,x*2,x])
        lcd.line(x,25, x,35)

    for x in range(0,32):
        lcd.setcol([x,0,0])#    Rotstufen
        lcd.line(x,35, x,45)

    for x in range(0,32):
        lcd.setcol([0,0,x])#    Blaustufen
        lcd.line(x,45, x,55)

    for x in range(0,64):
        lcd.setcol([0,x,0])#    Grünstufen
        lcd.line(x,55, x,65)

    if not lcd.LCDlicht:
        lcd.licht()

    farbzahl=len(lcd.farben)
    max_X= lcd.maxX+1
    schritt = max_X/ farbzahl
    
    for x in range(0, len(lcd.farben)):
        lcd.setcolBG(lcd.farben[x])
        lcd.box(x* schritt,0, x+1* schritt-1,20)

    lcd.display()

###########################   Hauptprogramm   ########################
Ltyp= "admatec"
#   *****************   Instanzen erzeugen   ***********************
taste=taste.Taste()
imp= imp.Import()
ports=ports.PORTS(Ltyp, 13,11, taste, imp)
ports.TFTini(Ltyp)
pwm= ports.gpio.PWM(ports.pwm,500)# ******   TFT-LEDlicht ein  ******
font=font.font
stop
lcd=lcd.LCD(pwm, ports, font)

print"Die LCD Befehle können nun verwendet werden"
print"Eine grobe Übersicht der Möglichkeiten kann mit 'dir(lcd' aufgerufen werden."
print"Dabei ist aber zu bechten, daß einige Nemen nur als intene Variablen"
print "verwendet werden und keine ausführbaren Befehle oder Prozeduren sind."
print"\nEin Test des TFT kann mit 'lcd_test()' aufgerufen werden"

