# -*- coding: utf-8 -*-
class LCD:
    def __init__(self, pwm, ports, font):
        from math import sin,cos,acos, pi

        #############################  defaultwerte start   #######################
        self.sin= sin; self.cos= cos; self.acos= acos; self.pi= pi
        self.maxX= 0x13f; self. maxY= 0xef

        self.fonts= font
        self.font=None
        self.zname=None
        self.zbreit=-1
        self.zhoch=-1
        self.zleer=-1
        self.xstart=0
        self.ystart=0

        self.PWM= 30.0# 50.0    ==========  Hintergrundbeleuchtung 30 %  ======
        self.pwm= pwm
        self.LCDlicht= False
        self.Invers= False
        self.ports= ports

        #   *******************   Farbtabelle erstellen   *********************
        #   0= schwarz, 1= rot, 2= grün, 3= blau, 4= gelb, 5= türkis,
        #   6= violett, 7= weiß
        fr= 0xff & 0x1f; fg= 0xff & 0x3f; fb= 0xff & 0x1f
        self.farben={0:[0,0,0],1:[fr, 0x00, 0x00], 2:[0x00, fg, 0x00],
                3:[0x00, 0x00, fb], 4:[fr, fg, 0], 5:[0, fg, fb],
                6:[fr, 0, fb], 15:[(fr/3*2),(fg/3*2),(fb/3*2)],
                9:[(fr >> 1),0x0,0x0], 10:[0x0,(fg >> 2),0x0],
                11:[0,0,(fb >> 1)], 12:[(fr >> 1),(fg >> 2),0],
                13:[0,(fg >> 2),(fb >> 1)], 14:[(fr >> 1),0,(fb >> 1)],
                8:[(fr/3), (fg/3), (fb/3)], 7:[fr, fg, fb],
                16:[int(fr*.94), int(fg*.94), int(fb*.94)], 17:[int(fr*.815), int(fg*.815), int(fb*.815)],
                18:[int(fr*.69), int(fg*.69), int(fb*.69)], 19:[int(fr*.565), int(fg*.565), int(fb*.565)],
                20:[int(fr*.44), int(fg*.44), int(fb*.44)], 21:[int(fr*.315), int(fg*.315), int(fb*.315)],
                22:[int(fr*.19), int(fg*.19), int(fb*.19)], 23:[int(fr*.065), int(fg*.065), int(fb*.065)],
                24:[int(fr*.82), int(fg* .82), int(fb* .82)], 25: [fr,(fg/2), (fb/2)],
                26:[(fr/2), fg, (fb/2)], 27:[(fr/2), (fg/2), fb],
                28:[fr, fg, (fb/2)], 29:[fr, (fg/2), fb], 30:[(fr/2), fg, fb],
                31:[int(fr*.16),int(fb* .16),int(fb* .16)]}

        self.farbe=[0,0]
        self.farbeBG=[0xff, 0xff]

        self.TXTmag= 1
        self.fill= 0
        self.screen=[]
        self.MEM_clear()
        print "self.__init__ wurde aufgerufen"


    def display(self):
        self.ports.schreibe(0x2a,[0,0])
        for y in xrange(0,240):
            self.ports.schreibe(0x2b, [0,y])
            self.ports.schreibe(0x2c, self.screen[y])



    def MEM_clear(self):
        zeile =self.farbeBG * (self.maxX+1)
        self.screen = [zeile[:] for y in range(0, self.maxY+1)]


    def licht(self):
        if self.LCDlicht== True:
            self.pwm.stop()
            self.LCDlicht= False
        elif self.LCDlicht== False:
            self.pwm.start(self.PWM)
            self.LCDlicht= True


    def fill_set(self, status):
        if status in[0,1]:
            self.fill= status
            return 0
        else:
            return"Status nicht möglich (Nur 0, 1 ist erlaubt)"

    def TXTmagn(self, multi):
        self.TXTmag= multi

    def fontlist(self):
        liste= dir(self.fonts)
        for x in liste:
            if not "__" in x:
                print x

    def fontset(self, fontsoll):
        liste=dir(self.fonts)
        if fontsoll in liste:
            self.font= dict(eval("self.fonts." + fontsoll))
            self.zhoch= self.font["ZH"]
            self.zbreit= self.font["ZB"]
            try:
                self.zleer= self.font["ZA"]
            except:
                self.zleer=2
            self.zname= fontsoll
        else:
            self.font= None
            self.zhoch= -1
            self.zbreit= -1
            self.zleer= -1
            self.zname= None



    def textR(self, txt):
        if self.zname[0] != "r":
            print"Keine Raster-Zeichensatz ausgewählt (", self.zname,")."
            print "Funktion 'textR' nicht möglich!"
            return 1, "Kein Rasterzeichensatz ausgewählt"
        ystartS= self.ystart
        xstartS= self.xstart

        ucode=None
        for buchst in txt:
            if ord(buchst)> 128 and not ucode:
                ucode= buchst
                continue
            if ucode:
                buchst= ucode+buchst
                ucode= None

            unter= 0
            try:
                lines=list(self.font[buchst])
            except KeyError:
                lines=list(self.font["."])
            if len(lines) > self.zbreit-1 or lines[0] < 0:
                unter= abs(lines.pop(0))
            line=[]
            for x in range(0, self.zhoch+ unter):                
                lsum=[]
                for bit in range(0, len(lines)):
                    erg= lines[bit] & 0x1
                    lines[bit] >>= 1
                    for loop in range(0, self.TXTmag):
                        if erg:
                            lsum+= (self.farbe)#            Vordergrundfarbe
                        else:
                            lsum+= (self.farbeBG)#           Hintergrundfarbe

                lsum+= (self.zleer* self.farbeBG)#       Zwischenraum anfügen
                for loop in xrange(0, self.TXTmag):
    #                    self.point(self.xstart, self.ystart)
    #                    self.ports.schreibe(0x2C, lsum)#    "RAMwr"
                    self.screen[self.ystart][self.xstart* 2:self.xstart* 2+ len(lsum)]=lsum#    "RAMwr"
                    self.ystart += 1                
            self.ystart= ystartS
            self.xstart += (self.zbreit+ self.zleer)* self.TXTmag


    def textV(self, txt):
        ystartS= self.ystart
        xstartS= self.xstart

        ucode=None
        for buchst in txt:
            if ord(buchst)> 128 and not ucode:
                ucode= buchst
                continue
            if ucode:
                buchst= ucode+buchst
                ucode= None
                
            self.stift= 0
            y_start= ystartS
            x_start= xstartS
            zeilen= list( self.font[buchst])
            while zeilen:
                erg1= zeilen.pop(0)
                if type(erg1)== int:#           Position (relativ)
                    erg2= zeilen.pop(0)
                    if self.stift:#             Zeichnen
                        self.line(x_start,y_start,
                                 x_start + erg1* self.TXTmag, y_start- erg2* self.TXTmag)
                    x_start +=  erg1* self.TXTmag#                      Positionieren
                    y_start -=  erg2* self.TXTmag
                    
                else:#                          Steuerung Stift
                    if erg1.upper()== "H":
                        self.stift= 0
                    elif erg1.upper()== "I":
                        self.stift= 1
            xstartS += (self.zbreit + self.zleer) * self.TXTmag


    def lineR(self, xplus, yplus):
        xstart= self.xstart
        ystart= self.ystart
        xstartS= self.xstart
        ystartS= self.ystart
        xdiv= xplus
        ydiv= yplus

        if abs(xdiv) >= abs(ydiv):#     **********   divX >= divY   **********
            if abs(ydiv) > 0:#  ydiv != 0
                yadd= abs(ydiv)/ float(abs(xdiv))
            else:
                yadd=0#         ydiv = 0
                
            if ydiv >= 0: yadd *= 1
            else: yadd *= -1
                    
            if xdiv < 0: schritt=-1
            else: schritt=1

            for x in range(xstart, xstart+ xplus+ schritt, schritt):
    #                self.point(int(x+.5), int(ystart+.5))
    #                self.ports.schreibe( 0x2C, self.farbe)#      "RAMwr"
    #                self.point(int(x+.5), int(ystart+.5))
                pX=int(x+.5)* 2
                pY=int(ystart+.5)
                self.screen[pY][pX: pX+ len(self.farbe)]= self.farbe#      "RAMwr"
                ystart += yadd
        else:#                          **********   divY > divX   **********
            if abs(xdiv) > 0:#  ydiv != 0
                xadd= abs(xdiv)/ float(abs(ydiv))
            else:
                xadd=0#         ydiv = 0
                
            if xdiv >= 0: xadd *= 1
            else: xadd *= -1

            if ydiv < 0: schritt=-1
            else: schritt=1

            for y in range(ystart, ystart+ yplus+ schritt, schritt):
    #                self.point(int(xstart+.5), int(y +.5))
    #                self.ports.schreibe( 0x2C, self.farbe)#      "RAMwr"
                pX=int(xstart+.5)* 2
                pY=int(y +.5)
                self.screen[pY][pX:pX+ len(self.farbe)]= self.farbe#      "RAMwr"
                xstart += xadd

        self.xstart= xstartS + xplus
        self.ystart= ystartS + yplus



    #    def line(self, xstart, ystart, xende=None, yende=None):
    def line_neu(self, xypaare):
        xyort=0
        xyanz, xyok= divmod(len(xypaare), 2)
        print xypaare, xyanz, xyok
        self.xypaare=xypaare

        if xyanz > 1:
            self.point(xypaare[xyort],xypaare[xyort+1])
            xyort += 2
        print "x,y",self.xstart, self.ystart
    #        if xende== None or yende== None:
    #            xende= xstart
    #            yende= ystart
    #            xstart= self.xstart
    #            ystart= self.ystart

        print "vor/ xyort, xyanz, xyanz:", xyort, xyanz, len(xypaare)
        for paar in xrange(xyort,len(xypaare), 2):
            print "PAAR , XYORT,xyanz-1:",paar , xyort,len(xypaare)
            print "vorher startx, starty:", self.xstart, self.ystart
            print "x/y paare:", xypaare[paar], xypaare[paar+1]
            self.xstart= xypaare[paar]
            self.ystart= xypaare[paar+1]
            print "nachher startx, starty:", self.xstart, self.ystart
            pass
        stop
        ystartS= ystart
        xstartS= xstart
        ydiv= yende-ystart
        xdiv= xende-xstart

        if abs(xdiv) >= abs(ydiv):#     **********   divX >= divY   **********
            if abs(ydiv) > 0:#  ydiv != 0
                yadd= abs(ydiv)/ float(abs(xdiv))
            else:
                yadd=0#         ydiv = 0
                
            if ydiv >= 0: yadd *= 1
            else: yadd *= -1

            if xdiv < 0: schritt=-1
            else: schritt=1

            for x in range(xstart, xende+ schritt, schritt):
    #                self.point(int(x+.5), int(ystart+.5))
    #                self.ports.schreibe( 0x2C, self.farbe)#      "RAMwr"
                pX=int(x+.5)* 2
                pY=int(ystart+.5)
                self.screen[int(ystart+.5)][int(x+.5):int(x+.5)+ len(self.farbe)]= self.farbe#      "RAMwr"
                ystart += yadd
        else:#                          **********   divY > divX   **********
            if abs(xdiv) > 0:#  ydiv != 0
                xadd= abs(xdiv)/ float(abs(ydiv))
            else:
                xadd=0#         ydiv = 0
                
            if xdiv >= 0: xadd *= 1
            else: xadd *= -1

            if ydiv < 0: schritt=-1
            else: schritt=1

            for y in range(ystart, yende+ schritt, schritt):
    #                self.point(int(xstart+.5), int(y +.5))
    #                self.ports.schreibe( 0x2C, self.farbe)#      "RAMwr"
                pX=int(xstart+.5)* 2
                pY=int(y +.5)
                self.screen[pY][pX:pX+ len(self.farbe)]= self.farbe#      "RAMwr"
                xstart += xadd




    def line(self, xstart, ystart, xende=None, yende=None):
        if xende== None or yende== None:
            xende= xstart
            yende= ystart
            xstart= self.xstart
            ystart= self.ystart
            
        ystartS= ystart
        xstartS= xstart
        ydiv= yende-ystart
        xdiv= xende-xstart

        if abs(xdiv) >= abs(ydiv):#     **********   divX >= divY   **********
            if abs(ydiv) > 0:#  ydiv != 0
                yadd= abs(ydiv)/ float(abs(xdiv))
            else:
                yadd=0#         ydiv = 0
                
            if ydiv >= 0: yadd *= 1
            else: yadd *= -1

            if xdiv < 0: schritt=-1
            else: schritt=1

            for x in range(xstart, xende+ schritt, schritt):
    #                self.point(int(x+.5), int(ystart+.5))
    #                self.ports.schreibe( 0x2C, self.farbe)#      "RAMwr"
                pX= int(x)*2#    * 2
                pY=int(ystart+.5)
#                self.screen[pY][pX:pX+ len(self.farbe)]= self.farbe#      "RAMwr"
                self.screen[pY][pX:pX+ len(self.farbe)]= self.farbe#      "RAMwr"
                ystart += yadd
        else:#                          **********   divY > divX   **********
            if abs(xdiv) > 0:#  ydiv != 0
                xadd= abs(xdiv)/ float(abs(ydiv))
            else:
                xadd=0#         ydiv = 0
                
            if xdiv >= 0: xadd *= 1
            else: xadd *= -1

            if ydiv < 0: schritt=-1
            else: schritt=1

            for y in range(ystart, yende+ schritt, schritt):
    #                self.point(int(xstart+.5), int(y +.5))
    #                self.ports.schreibe( 0x2C, self.farbe)#      "RAMwr"
                pX=int(xstart)*2#    * 2
                pY=int(y +.5)
                self.screen[pY][pX:pX+ len(self.farbe)]= self.farbe#      "RAMwr"
                xstart += xadd
        self.xstart=int(xende)
        self.ystart=int(yende)

    def box(self, xstart, ystart, xende, yende):
        if self.fill:
            daten= self.farbeBG * (abs(xende-xstart)+1)
            if ystart <= yende:
                start= ystart; ende= yende+1
            else:
                start= yende; ende= ystart+1
                
            for y in range(start, ende+1):
    #                self.point(xstart, y)
    #                self.ports.schreibe(0x2c, daten)
                pX=xstart*2
                pY=y
                self.screen[pY][pX:pX+ len(daten)]= daten
        else:
            self.line(xstart, ystart, xende, ystart)
            self.line(xende, ystart, xende, yende)
            self.line(xende, yende, xstart, yende)
            self.line(xstart, yende, xstart, ystart)


    def circle (self, xpoint, ypoint, radius):        
        step= 2* self.pi /(radius* 5)
        if self.fill:
            for y in range(0, radius+ 1):
                pipoint0= self.sin(self.acos(y/ float(radius)))
                pipointR= pipoint0 * radius
                xlang= int(pipointR * 2)
                pX=int(xpoint- pipointR)* 2
                pY=ypoint- y
    #                self.point(int(xpoint- pipointR), ypoint- y)
    #                self.ports.schreibe(0x2C, self.farbeBG * xlang)#       "RAMwr"
                self.screen[pY][pX:pX+ len(self.farbeBG * xlang)]= self.farbeBG * xlang#       "RAMwr"

    #                self.point(int(xpoint- pipointR), ypoint+ y)
    #                self.ports.schreibe(0x2C, self.farbeBG * xlang)#       "RAMwr"
                pX=int(xpoint- pipointR)* 2
                pY=ypoint+ y
                self.screen[pY][pX:pX+ len(self.farbeBG * xlang)]= self.farbeBG * xlang#       "RAMwr"
        else:
            for x in range(0, int((2* self.pi)*100) + int(step*100), int(step*100)):
                pX=int(xpoint+ ((self.sin(x/100.0))* radius))
                pY=int(ypoint+ ((self.cos(x/100.0))* radius))
    #                self.point(int(xpoint+ ((self.sin(x/100.0))* radius)),
    #                      int(ypoint+ ((self.cos(x/100.0))* radius)))
    #                self.point(pX, pY)
    #                self.ports.schreibe(0x2C, self.farbe)#       "RAMwr"
                self.screen[pY][pX:pX+ len(self.farbe)]= self.farbe#       "RAMwr"


    def point(self, xstart, ystart):
        x1,x0= divmod(xstart,0x100)
        #   CAset'          Xstart, Xende
        self.ports.schreibe(0x2A, [x1,x0])#    max= 0xef#     "CAset"
        #   RAset'          Ystart, Yende
        self.ports.schreibe(0x2B, [0,ystart])#   max= 0x13f# "RAset"
        self.xstart= xstart
        self.ystart= ystart


    def TFT_del(self, Xmax= 0x13f, Ymax= 0xef, farbe=[0xff, 0xff]):#           LCD löschen         #
        xmax1,xmax2= divmod(Xmax, 0x100)
        ymax1,ymax2= divmod(Ymax, 0x100)

    #   CAset'                  Xstart, Xende
        CARAdaten= [0,0, xmax1, (xmax2)]
        self.ports.schreibe(0x2A, CARAdaten)#    max= 0x13f#     "CAset"

    #   RAset'                  Ystart, Yende
        CARAdaten= [0,0, ymax1, (ymax2)]
        self.ports.schreibe(0x2B, CARAdaten)#    max= 0xef#      "RAset"
        self.MEM_clear()
        return

        Fdaten= (Xmax+1) * farbe
        tstart=time()
        for y in range(0,Ymax+1):
            print y,
            self.ports.schreibe(0x3c, Fdaten)
    ###            self.screen[y]= Fdaten



    def setcol(self, farbe):
    #   RGB (5-6-5)= 2 Byte | 64k
        LCD_r= (farbe[0]& 0x1f) << 3
    #        LCD_r= (farbe[0]& 0x1f) << 5
        LCD_g1= (farbe[1]& 0x38) >> 3; LCD_g2= (farbe[1] & 0x07) << 5
        LCD_b= farbe[2] & 0x1f
        self.farbe= [LCD_r | LCD_g1, LCD_g2 | LCD_b]


    def setcolBG(self, farbe):
    #   64k RGB (5-6-5) = 2 Byte
        LCD_r= (farbe[0]& 0x1f) << 3#   5
        LCD_g1= (farbe[1]& 0x38) >> 3; LCD_g2= (farbe[1] & 0x07) << 5
        LCD_b= farbe[2] & 0x1f
        self.farbeBG= [LCD_r | LCD_g1, LCD_g2 | LCD_b]


    def pen(self,farbe):
        self.setcol(self.farben[farbe])


    def penBG(self,farbe):
        self.setcolBG(self.farben[farbe])
