# -*- coding: utf-8 -*-
class PORTS:
    def __init__(self, LCDtyp, T1, T2, taste, imp):
        import RPi.GPIO
        import spidev
        self.pins={"admatec": {"pwm": 12, "RST": 22, "RS": 15,
                               "SDA": 19, "MISO": 21, "SCL": 23, "CS0": 24},
                   "adafruit":{"pwm": 18, "RS": 22, "SDA": 19, "MISO":21,
                               "SCL": 23,"CS0": 24, "CS1": 26}}

        pinsLCD= self.pins[LCDtyp]
        print "LCD-Type", LCDtyp,
        print "TASTE 1, TASTE 2", T1, T2

        self.Ltype= LCDtyp
        self.IMP= imp
        self.gpio= RPi.GPIO
        self.gpio.setmode(self.gpio.BOARD)
        try:
            self.RS= pinsLCD["RS"]
            self.gpio.setup(self.RS, self.gpio.OUT)
        except: print"RS nicht gefunden"
        try:
            self.CS0= pinsLCD["CS0"]
            self.gpio.setup(self.CS0, self.gpio.OUT)
        except: print"CS0 nicht gefunden"
        try:
            self.RST= pinsLCD["RST"]
            self.gpio.setup(self.RST, self.gpio.OUT)
        except: print"RST nicht gefunden"
        try:
            self.pwm= pinsLCD["pwm"]
            self.gpio.setup(self.pwm, self.gpio.OUT) 
        except: print"pwm nicht gefunden"

        try:
            self.CS1= pinsLCD["CS1"]
            self.gpio.setup(self.CS1, self.gpio.OUT) 
        except: print"CS1 nicht gefunden"

        self.taste= taste
        self.ADC= 15
        self.gpio.setup(self.ADC,self.gpio.OUT)
        self.TST= 7
        self.gpio.setup(self.TST,self.gpio.OUT)

        #############################  defaultwerte start   #######################
    ###        self.LCDtyp= LCDtyp
    ###        self.lichtPin= LCDlicht#                    GPIO-Pin für Licht
    ###        self.lichtAN= True#                         LCD_licht=True
        self.T1=T1
        self.T2=T2
    ###        self.modus=modus

        ######################  GPIO Taste 1  für Interrupt vorbereiten
        self.gpio.setup(self.T1, self.gpio.IN, pull_up_down = self.gpio.PUD_UP)
        self.gpio.add_event_detect(self.T1, self.gpio.FALLING, callback = self.taste.GPIO_Int_Taste, bouncetime = 100)
        ######################  GPIO Taste 2  für Interrupt vorbereiten
        self.gpio.setup(self.T2, self.gpio.IN, pull_up_down = self.gpio.PUD_UP)
        self.gpio.add_event_detect(self.T2, self.gpio.FALLING, callback = self.taste.GPIO_Int_Taste, bouncetime = 100)

        if self.Ltype== "admatec":
            self.spiREADhz= 1024 << 13#     ******   SPI LESE-Takt      ******
            self.spiWRITEhz= 1024 << 16#    ******   SPI SCHREIB-Takt   ******
            self.spiADChz=  1024 << 13
        else:
            self.spiREADhz= 1024 << 13#     ******   SPI LESE-Takt      ******
            self.spiWRITEhz= 1024 << 16#    (10)******   SPI SCHREIB-Takt   ******

        self.spi = spidev.SpiDev()
        self.spi.open(0, 0)#                mit CS0 !!!
        
        self.spi.max_speed_hz= (self.spiWRITEhz)#       SPI Taktfrequenz setzen
        self.spi.threewire = False
        print"SPI Frequenz (kHz):", self.spi.max_speed_hz/1024

        self.gein= self.gpio.HIGH
        self.gaus= self.gpio.LOW

        self.control = 0
        self.data = 1
        
    #        print "ein, aus:", self.gein, self.gaus
    #        print "control, data:", self.control, self.data
        print""

        if self.Ltype== "admatec":
            self.TFTreset()


    def gpioex_read(self, reg, anz):#             Adressbit D7= 0  ==> write
        ret_gpe1= self.spi.xfer2([reg | 0x80,0])#  Adresse schreiben
        self.IMP.time.sleep(.01)
        ret_gpe2= self.spi.xfer2([0]* anz)
        return ret_gpe1, ret_gpe2
        

    def gpioex_write(self, reg, wert):#             Adressbit D7= 0  ==> write
        ret_gpe1= self.spi.xfer2([reg, wert])#  Adresse schreiben
        ret_gpe2= self.spi.xfer2([reg, wert])
        return ret_gpe1, ret_gpe2


    def gpioerg(self,reg):
        erg= self.gpioex_read(reg,1);
        print hex(erg[1])
        return erg[1:]


    def schreibe(self, reg, werte):
        self.gpio.output(self.RS, self.control)
        ret_spi= self.spi.xfer([reg])

        if len(werte)>0:
            self.gpio.output(self.RS, self.data)
            ret_spi= self.spi.xfer2(werte)


    #    def schreibe_ori(self, reg, werte):
    #        self.gpio.output(self.CS0,0)#          CS0 LOW
    #        self.gpio.output(self.RS, self.control)
    #    #    print "REG:", hex(reg),

    #        ret_spi= self.spi.writebytes([reg])
    #    print text," return1:", ret_spi,

    #        if len(werte)>0:
    #            self.gpio.output(self.RS, self.data)
    #            ret_spi= self.spi.writebytes(werte)
    #    #        print text,"return2:", ret_spi
    #        self.gpio.output(self.CS0,1)#          CS0 HIGH



    #    def lese_ori(self, reg, anz):
    #        self.spi.max_speed_hz= (1024) << 10
    #        self.gpio.output(self.CS0,0)#          CS0 LOW
    #        #self.gpio.output(self.CS1,1)#          CS0 LOW
    #        self.gpio.output(self.RS, self.control)
    #        print "REG:", hex(reg),

    #        ret_spi= self.spi.writebytes([reg])
    #        print " return1:", ret_spi,

    #        self.gpio.output(self.CS0,0)#          CS0 LOW
    #        self.gpio.output(self.RS, self.data)
    #        ret_spi= self.spi.readbytes(anz)
    #        print "return2:",
    #        for x in ret_spi:
    #            print hex(x),
    #        print
    #        self.gpio.output(self.CS0,1)#          CS0 LOW
    #        return 0, ret_spi



    def lese(self, reg, anz):
        self.gpio.output(self.RS, self.control)
        print "REG:", hex(reg),

        self.spi.max_speed_hz= self.spiREADhz

        ret_spi1= self.spi.xfer2([reg]+ [0]* anz)
        self.gpio.output(self.RS, self.data)

        self.spi.max_speed_hz= self.spiWRITEhz
        return ret_spi1


    #    def lese_neu(self, reg, anz, druck=1):
    #        self.gpio.output(self.RS, self.control)
    #        print "REG:", hex(reg),

    #        self.spi.max_speed_hz= self.spiREADhz#          Lesetakt reduzieren
    #        ret_spi1= self.spi.xfer([reg])
    #        print " return1:", ret_spi1,

    #        self.gpio.output(self.RS, self.data)
    #        ret_spi2= self.spi.xfer2([0]*anz)
    #        self.spi.max_speed_hz= self.spiWRITEhz#         Schreibtakt wiederherstellen
    #        return ret_spi1, ret_spi2

    def TFTreset(self):        #   reset
        self.gpio.output(self.RST, self.gaus)
        self.IMP.time.sleep(.01)
        self.gpio.output(self.RST, self.gein)
        self.IMP.time.sleep(.1)

    def TFTini(self, Ltyp):#  *******************   TFT-INIT   **********************
        print"LCD-Typ ini:", Ltyp
        if Ltyp=="admatec":
            #   SLPout
            self.schreibe(0x11, [])#                    "DISPon"
            #   MADctl
            self.schreibe(0x36, [0xA0])#                "MADctl"
            #   COLmod
            #   "Text", REG, Werte, GPIO Board PIN
            self.schreibe(0x3A, [0x55])#                "COLmod"
            #   PORctl
            self.schreibe(0xB2, [0x0C,0x0C,0,0x33,0x33])#   "PORctl"
            ##   Gctrl
            self.schreibe(0xB7, [0x35])#                "invON"
            ##   VDVVRHen
            self.schreibe(0xC2, [1, 0xff])#             "VDVVRHen"
            ##   VRHs
            self.schreibe(0xC3, [0x17])#                "VRHs"
            ##   VDVs
            self.schreibe(0xC4, [1, 0x20])#             "VDVs"
            ##   VCOMs
            self.schreibe(0xBB, [1, 0x17])#             "VCOMs"
            ##   VCMOofSET
            self.schreibe(0xC5, [0x20])#                "VCMOofSET"
            ##   PWctrl1
            self.schreibe(0xD0, [0xA4, 0xA1])#          "PWctrl1"
            ##   PVgamCTRL
            self.schreibe(0xE0, [0xD0, 0x00, 0x14, 0x15, 0x13, 0x2C, 0x42,
                                 0x43, 0x4E, 0x09, 0x16, 0x14, 0x18, 0x21])#    "PVgamCTRL"
            #   NVgamCTRL
            self.schreibe(0xE1, [0xD0, 0x00, 0x14, 0x15, 0x13, 0x0B, 0x43,
                                 0x55, 0x53, 0x0C, 0x17, 0x14, 0x23, 0x20])#    "NVgamctl"

            #   WRdisBV
            self.schreibe(0x51, [0xa0])#                "WRdisBV"
            #   WRctrlD
            #schreibe("WRctrlD", 0x53, [0x2C], pins["RS"], pins["CS0"])
            #   WRcabcMB
            self.schreibe(0x5E, [0x80])#                "WRcabcMB"

        else:   #       adafruit
            print "LCD-Typ:", "adafruit"
    #            self.gpio.output(18,0)
            self.schreibe(0x01,[])#                     SW-Reset
            self.IMP.time.sleep(.005)
            self.schreibe(0x28,[])#                     Display off

    ###            self.schreibe(0xcf,[0, 0x83, 0x30])#  
    ###            self.schreibe(0xed,[0x64, 0x03, 0x12, 0x81])
    ###            self.schreibe(0xe8,[0x85, 0x01, 0x79])
    ###            self.schreibe(0xcb,[0x39, 0x2c, 0, 0x34, 0x02])
    ###            self.schreibe(0xf7,[0x20])
    ###            self.schreibe(0xea,[0, 0])
            #   power controll
            self.schreibe(0xc0,[0x26])#     Power Control 1  (4,75V)
            self.schreibe(0xc1,[0x11])#     Power Control 2  (x2, x7, x3)
            #   VCOM
            self.schreibe(0xc5,[0x35, 0x3e])#   Control 1   (4,025V/ -0,950V)
            self.schreibe(0xc7,[0xbe])#         Control 2   (-2/ -2)
            #   memory access control
            self.schreibe(0x36,[0xe0])#         Memory Access Control   (My, Mx, Mv)
    #            self.schreibe(0x3a,[0x55])
            self.schreibe(0x3a,[0x05])#         Pixel Format Set        (16/ pixel)
            #   frame rate
            self.schreibe(0xb1,[0, 0x1b])   #   Control                 (fosc, 27 Clk)
            #   Gamma
    #            self.schreibe(0xf2,[0x08])#               Function disable
    ###            self.schreibe(0x26,[0x01])#                  set 4  (curve 01)
                #correction pos
            self.schreibe(0xe0,[0x1f, 0x1a, 0x18, 0x0a, 0x0f, 0x06, 0x45,
                                0x87, 0x32, 0x0a, 0x07, 0x02, 0x07, 0x05, 0])
                #correction neg
            self.schreibe(0xe1,[0, 0x25, 0x27, 0x05, 0x10, 0x09, 0x3a, 0x78,
                                0x4d, 0x05, 0x18, 0x0d, 0x38, 0x3a, 0x1f])
            #   ddram
    ###            self.schreibe(0x2a,[0, 0, 0, 0xef])#      column
    ###            self.schreibe(0x2b,[0, 0, 1,0x3f])#      page
    ###            self.schreibe(0x34,[])#                     tearing off (35= on)
    ###            self.schreibe(0xb4,[0])#                      invers
    ###            self.schreibe(0xb7,[0x07])#                   entry mode

            #   display
            self.schreibe(0x13,[])#                         partial off
            self.schreibe(0x38,[])

    ###            self.schreibe(0xb6,[0x0a, 0x82, 0x27, 0])#  Function Control
            self.schreibe(0x11,[])#                         sleep off
            self.IMP.time.sleep(.1)
            self.schreibe(0x29,[])#                         display on
            self.IMP.time.sleep(.1)

        #   ******************  maximalen LCD-Bereich festlegen   *********************
        #   CAset'          Xstart, Xende
        self.schreibe(0x2A, [0,0, 1,0x3f])#    max= 0x13f   #      "CAset"
        #   RAset'          Ystart, Yende
        self.schreibe(0x2B, [0,0, 0,0xef])#    max= 0xef    #       "RAset"

        self.LCDonoff(True)


    def invers(self, stat):
        if stat== True:
            self.schreibe(0x21, [])#       "invON"
        else:
            self.schreibe(0x20, [])#       "INVoff"

    def LCDonoff(self, stat):#       DISPLAY on/off
        if stat== True:
            self.schreibe(0x29, [])#        "DISPon"
        else:
            self.schreibe(0x28, [])#        "DISPoff"
