#!/usr/bin/env python
# -*- coding: utf-8 -*-


class LCD:
    def __init__(self, LCDtyp, LCDlicht, RS, T1, T2, modus, IMP, TASTE, FONT):
        print "LCD __init__ wurde aufgerufen"

        #---------------------- Übersetzung Wochentag  ----------------------------
        self.WochenTag = {"Monday": "Montag", "Tuesday": "Dienstag", "Wednesday": "Mittwoch",
                     "Thursday": "Donnerstag", "Friday": "Freitag", "Saturday": "Samstag",
                     "Sunday": "Sonntag"}


        #############################  defaultwerte start   #######################
        self.config={}

        self.LCDtyp= LCDtyp
        self.lichtPin= LCDlicht#                    GPIO-Pin für Licht
        self.lichtAN= True#                         LCD_licht=True
        self.RS= RS
        self.T1=T1
        self.T2=T2
        self.modus=modus
        self.IMP= IMP
        self.TASTE= TASTE
        self.FONT= FONT

        self.test= False               # Default: Tests = NEIN
        self.config["kontrast"]= 0x5f           # Defaultwert Kontrast 0X10 (0-0XFF)
        self.config["invers"] = False            # Defaultwert LCD invers (falsch [nein])

        self.Tdir= 0
        self.ArtMax_add= 0                #HM
        self.M_insertFLR= None
        self.Feld_Reihenfolge=[1,8,11,2,7,3,9]
        self.Lfolge = [(0,1,2,1),(2,1,2,3),(2,3,0,3),(0,3,0,1)]

        self.mode = 2
        self.shift = (self.mode==0 and 3) or (self.mode==1 and 1) or (self.mode==2 and 2) or 0
        self.werte = [self.shift, self.mode]#   , 240, 128]

        self.config["W14inter"] = 6              # IntervallZeit für 14 Tage Wetter
        self.config["W14Code"] ="DE0001111"      # Defaultwert Ortscode 'wetter.com'
        self.config["HMlogDat"] = ""
#        self.config["HardCopy"] = 0                # GIF Bildschirmkopie (nein)

        self.config["debug"]= 0                     #HM Defaultwert Degug (0 = Nein)
        self.config["LCD_test"]=0                  #HM Vor Programmablauf LCD-Test starten (0 = Nein)
        self.config["test"]= 0
        self.config["ErrAnz"]=0                    #HM Durchlaufzähler, Fehler-Art & -Anzahl anzeigen (0 = Nein)
        self.config["Anz_Art"]=1                 #HM Start - 'Bildschirm'   1
        self.config["ArtMax_add"]=0                #HM

        self.config["StartFolge"]=7
        self.config["AutoLauf"]=1

        self.dirStat = 0
        self.penstat= 1
        self.taste = ""

        self.config["IP_addr"]="192.168.178.1"     # Defaultwert IP-Adresse

        #   HM_Debug=0                  #HM Debug wird nicht mehr unterstützt (0 = Nein)
        #   currentX=0'     jetzt: self.posX
        #   currentY=0'     jetzt: self.posY
        Tstart = self.IMP.time.time()
        Zbreit = 6

        #############################  defaultwerte ende   ########################

        #########################  Config-Datei laden  Start   #######################
        self.einDatei = open("./LCD240config.txt","r")

        for param in self.einDatei:
            parWert = param.strip().split(":")

            if parWert[0][0] != "#":#           ########  KEINE Kommentare!   ########
                if parWert[0] == "IP_ADDR":
                    self.IP_addr = parWert[1]
                    cText = "IP_addr"
                elif parWert[0] == "LCD_CONTR":
                    self.kontrast = eval(parWert[1])
                    cText = "kontrast"
                elif parWert[0] == "TEST":
                    self.test = bool(int(parWert[1]))
                    cText = "LCD_test"
                elif parWert[0] == "INVERS":
                    self.invers = bool(int(parWert[1]))
                    cText = "invers"
                elif parWert[0] == "W14CODE":
                    self.W14Code = parWert[1]
                    cText = "W14Code"
                elif parWert[0] == "W14INTERV":
                    M_W14inter = parWert[1]
                    cText = "W14inter"
                elif parWert[0] == "HardCopy":
                    HardCopy = int(parWert[1])
                    print"Debug wird nicht mehr unterstützt!"
                    debug=int(parWert[1])
                    cText = "HardCopy"
                elif parWert[0] == "W05CODE":
                    self.W05Code= parWert[1]
                    cText= "W05Code"

                elif parWert[0] == "EDLpfad":
                    EDL_pfad = parWert[1]
                    cText = "EDLpfad"

                elif parWert[0] == "EDLip":
                    EDL_pfad = parWert[1]
                    cText = "EDLip"

                elif parWert[0] == "EDLport":
                    EDL_pfad = parWert[1]
                    cText = "EDLport"

                elif parWert[0] == "WRip":
                    EDL_pfad = parWert[1]
                    cText = "WRip"

                ########################################    HM_config
                elif parWert[0] =="HM_Debug":
                    print"Debug wird nicht mehr unterstützt!"
                    debug=int(parWert[1])
                    cText = "debug"

                elif parWert[0] == "test":
                    self.LCD_test=int(parWert[1])
                    if self.LCD_test>1:
                        self.LCD_test=1
                    elif self.LCD_test<0:
                        self.LCD_test=0
                    cText = "LCD-test"

                elif parWert[0] == "HM_ErrorAnz":
                    self.ErrAnz=int(parWert[1])
                    if self.ErrAnz> 1:
                        self.ErrAnz= 1
                    if self.ErrAnz< 0:
                        self.ErrAnz= 0

                    self.ArtMax_add= 1
                    cText = "ErrAnz"

                elif parWert[0] == "HM_StartFolge":
                    self.Anz_Art=int(parWert[1])
                    if self.Anz_Art> 7:
                        self.Anz_Art= 1
                    if self.Anz_Art< 0:
                        self.Anz_Art= 0
                    cText = "HM StartScript"

                elif parWert[0] == "AutoLauf":
                    print"Parameter ", parWert, " wird nicht unterstützt"
                    self.config["AutoLauf"]=int(parWert[1])
                    #continue

                else:
                    print"Parameter", parWert, " ist unbekannt"
                    continue

                self.config[cText]= parWert[1]

        self.einDatei.close()

        #########################  Config-Datei laden  ende   #######################

#        ##########################   Menü-Datei laden   ############################
#        self.Mzuord = {}
#        self.Menu = []
#        try:
#            datSuch = "./LCDmenueS.txt"
#            self.D_in = open(datSuch, "r")
#        except:
#            muster = "=" * 25
#            print"\n" + muster + "   Programmabbruch   " + muster
#            print"Datei '" + datSuch + "' kann in aktuellem Verzeichnis nicht gefunden werden."
#            quit
#        Mein = self.D_in.readlines()
#        for x in Mein:
#            if x[0] == "#":#       ####   Kommentarzeilen ausblenden   ######
#                continue
#            Mzeile = x.strip().split(":")
#            self.Mzuord[int(Mzeile[0])] = Mzeile[1]
#            self.Menu.append(Mzeile[2])
#        self.D_in.close()
#        ##########################   Menü-Datei laden  Ende  ##########################


        if self.LCDtyp=="EA DOGXL240":
            self.posX=0; self.posY=0
            self.maxX=240; self.maxY=128
#            self.maxX= 10; self.maxY=10

        elif self.LCDtyp=="EA DOGL128":
            self.posX= 0; self.posY= 0
            self.maxX= 128; self.maxY= 64

        else:
            self.posX=-1; self.posY=-1
            self.maxX=-1; self.maxY=-1
            self.LCDtyp="-1"

        if self.LCDtyp != "-1":
            self.GpioSpi_ini(self.IMP.time, self.modus)
            self.LCD_init(self.IMP.time)
            self.MEM_clear()

            self.FONT.font(2)
            if self.FONT.Name == "-1":
                "Standard-Zeichensatz kann nicht gelladen werden. PROGRAMMABBRUCH!"
                stop

            # Vorgereitungen für Grafikdisplay
            self.LCD_clear()


    def get_XY(self):
        return(self.posX, self.posY)

    def get_maxXY(self):
        return(self.maxX, self.maxY)

    def GpioSpi_ini(self, time, modus):
        self.SPI = self.IMP.spidev.SpiDev()
        self.modus= modus

        self.IMP.time.sleep(.25)
        self.IMP.GPIO.setmode(eval("self.IMP.GPIO." + self.modus))
#        IMP.GPIO.setmode(IMP.GPIO.BCM)
        self.IMP.GPIO.setup(self.lichtPin, self.IMP.GPIO.OUT)
        self.IMP.GPIO.setup(self.RS, self.IMP.GPIO.OUT)

        ######################  GPIO Taste 1 (GPIO 4) für Interrupt vorbereiten
        self.IMP.GPIO.setup(self.T1, self.IMP.GPIO.IN, pull_up_down = self.IMP.GPIO.PUD_DOWN)
        self.IMP.GPIO.add_event_detect(self.T1, self.IMP.GPIO.RISING, callback = self.TASTE.GPIO_Int_T1, bouncetime = 100)

        ######################  GPIO Taste 2 (GPIO 14) für Interrupt vorbereiten
        self.IMP.GPIO.setup(self.T2, self.IMP.GPIO.IN, pull_up_down = self.IMP.GPIO.PUD_DOWN)
        self.IMP.GPIO.add_event_detect(self.T2, self.IMP.GPIO.RISING, callback = self.TASTE.GPIO_Int_T1, bouncetime = 100)

        #### Setze SPI Takt ########   * Minimum: 1024 << 4 = 16 kHz
        spiTakt = 4096 << 10     #       4096 << 9 = 4,096 MHz
        self.SPI.open(0,0)
        self.SPI.max_speed_hz = (spiTakt)
        print "SPI-Taktfrequenz (kHz):", self.SPI.max_speed_hz/ 1024


    def GPIO_pins(self):
        return(("Licht",self.lichtPin),("RS", self.RS),
               ("Taste 1",self.T1),("Taste 2", self.T2))


    def LCD_close(self):
        antwort = self.SPI.xfer2([0xAE])
        print"Display aus", antwort
        self.SPI.close
        self.IMP.GPIO.cleanup()

    def LCD_init(self, time):

#        print"*** Kontrast (hex):",hex(self.kontrast)
        # Init LCD EA DOGLXL240-7 3.3V
        # 0xF1 = Common End = 127 (Spaltenbreite)
        # 0x7F
        # 0xF2 = Part.-Display start line 0
        # 0x00
        # 0xF3 = Part.-Display end line 127
        # 0x7F
        # 0x81 = VBias Potentiometer (Contrast)
        # VARIABLENWERT (kontrast)
        # 0xA3 = Line rate 9.4 | 21.4 |22.5 | 32.0 kLines /sec
        # 0x25 = Temp. Compensation -0.10%/°C

        # 0x60 = Page Address 0
        # 0x70
        # 0x2B = Panel Loading 33...55 nF
        # 0x2F = Pump Control intern x 11

        # 0xC0 = LCD mapping control (bottom)
        # 0x02
        # 0x88 = RAM Adress Control (no Auto increment)
        # 0xAx = Display invers (0xA6 | M_invers)
        # 0xAD = Display on (4 Graustufen)
        # 0xD1 = Schwarz/Weiß
        # 0xEB = LCD bias 1/12

        print "LCD selbst Initiieren"
        self.IMP.GPIO.output(self.RS,0)
        self.IMP.time.sleep(.05)
        antwort =self.SPI.xfer2([0xF1, 0x7F, 0xF2, 0x00, 0xF3, 0x7F, 0x81, self.kontrast, 0xA3, 0x25, \
                            0x60, 0x70, 0x2B, 0x2F, 0x88, 0xC0, 0x02, 0xA6 | self.invers, 0xD0, 0xAD])


    def LCD_clear(self):#          (shift, mode, breit, hoch)
        breit = self.maxX
        self.IMP.GPIO.output(self.RS,0)
        antwort= self.SPI.xfer2([0x40, 0x50])    # Start Scroll-Line 0

        for seite in range(0,self.maxY/2):#	(Page 0 bis 63)
            sl=seite % 16
            sm = seite // 16
            antwort= self.SPI.xfer2([0x60 | sl])   #    Page LSB 0
            antwort= self.SPI.xfer2([0x70 | sm])   #    Page MSB 0
            antwort= self.SPI.xfer2([0x00, 0x10])     #    Column 0

            self.IMP.GPIO.output(self.RS,1)
            antwort= self.SPI.xfer2([0x00] * breit)
            self.IMP.GPIO.output(self.RS,0)


    def display(self):
        for x in range(0, self.maxY/2 -1):
            Dout = self.screen[x]
#            self.LCD1.plot(Dout[:],x)
            self.plot(Dout[:],x)


    def LCD_ende(self):
        if self.FONT.Name != "r5x8":
            font_ret = self.FONT.font(2)
        print"LCD beenden"
        antwort= self.TextG("*  HM LCD-Monitor  *",1)           #LCD HM-Monitor Ende
        antwort= self.TextG("*" + " " * 18 + "*",2)
        antwort= self.TextG("*" +"ENDE".center(18," ") +"*",3)  #Hinweistext


    def plot(self, S_data, S_Zeile=0, S_Spalte=0):
        self.IMP.GPIO.output(self.RS,0)
        zeile = S_Zeile
        msb = zeile //16
        lsb = zeile % 16
        antwort=self.SPI.xfer2([0x60 | lsb])  #    Setze Zeile (Page)
        antwort=self.SPI.xfer2([0x70 | msb])  #    Setze Zeile (Page)
        antwort=self.SPI.xfer2([0x10, 0x00])             #    Column 0

        self.IMP.GPIO.output(self.RS,1)
        antwort=self.SPI.xfer2(S_data)
        self.IMP.GPIO.output(self.RS,0)


    def tempDif(self, wert):
        S_find = wert.find(".")
        if S_find:
            temp_S = wert[:S_find] + "," + wert[S_find+1]
        else:
            return wert
        return temp_S

    def Zusatz_FLR(self, S_nr, S_zusatz):
        try:
            M_Etage= self.Feld_Reihenfolge.index(S_nr)
        except:
            M_Etage=""#   None
        print ((S_nr==4 and "Licht") or (S_nr==5 and "Fenster") or \
               (S_nr==6 and "Rollo")) + "_gesamt",
        M_such_IDX=S_nr

        if S_zusatz==1:#        Zustand ist EIN (1)
            print"'ist " + str((S_nr==4 and "ein") or (S_nr==5 and "auf") or (S_nr==6 and "oben")) +"'",

            if M_Etage=="":
                M_stelle= self.Feld_Reihenfolge.index(self.M_insertFLR)

                print"einfügen bei index",M_stelle
                self.Feld_Reihenfolge.insert(M_stelle,S_nr)
                print "Feld", self.Feld_Reihenfolge,
                print "Einfügen vor Wert",self.M_insertFLR," mit Index", self.Feld_Reihenfolge.index(self.M_insertFLR)
        else:#                  Zustand ist AUS (0)
            print"'ist " + str((S_nr==4 and "aus") or (S_nr==5 and "zu") or (S_nr==6 and "unten")) +"'"
            if M_Etage<>"":
                print"lösche Script '"+ str(S_nr) +"'", self.Feld_Reihenfolge.remove(S_nr)
                print "Feld_Reihenfolge =", self.Feld_Reihenfolge
                S_Zusatz=0

    def Zusatz_FLR__loeschen___(self, S_nr,S_zusatz):
        try:
            M_Etage=self.LCD1.Feld_Reihenfolge.index(S_nr)
        except:
            M_Etage=""#   None
        print ((S_nr==4 and "Licht") or (S_nr==5 and "Fenster") or \
               (S_nr==6 and "Rollo")) + "_gesamt",
        M_such_IDX=S_nr

        if S_zusatz==1:#        Zustand ist EIN (1)
            print"'ist " + str((S_nr==4 and "ein") or (S_nr==5 and "auf") or (S_nr==6 and "oben")) +"'",

            if M_Etage=="":
                M_stelle=self.LCD1.Feld_Reihenfolge.index(LCD1.M_insertFLR)

                print"einfügen bei index",M_stelle
                self.LCD1.Feld_Reihenfolge.insert(M_stelle,S_nr)
                print "Feld", self.LCD1.Feld_Reihenfolge,
                print "Einfügen vor Wert",self.LCD1.M_insertFLR," mit Index", self.LCD1.Feld_Reihenfolge.index(self.LCD1.M_insertFLR)
        else:#                  Zustand ist AUS (0)
            print"'ist " + str((S_nr==4 and "aus") or (S_nr==5 and "zu") or (S_nr==6 and "unten")) +"'"
            if M_Etage<>"":
                print"lösche Script '"+ str(S_nr) +"'", self.LCD1.Feld_Reihenfolge.remove(S_nr)
                print "Feld_Reihenfolge =", self.LCD1.Feld_Reihenfolge
                S_Zusatz=0

    def Zusatz_SM(self, S_nr,S_zusatz):#  (Index = 12 / SM Anzahl) 

        try:
            M_Etage=self.LCD1.Feld_Reihenfolge.index(S_nr)
        except:
            M_Etage=""#   None
        print ((S_nr==12 and "ServiceMeldungen")),
        M_such_IDX=S_nr

        if S_zusatz > 0:#        SM Anzahl (>0)
            print str((S_nr==12 and "vorhanden")),

            if M_Etage=="":
                M_insert_findS= self.LCD1.Feld_Reihenfolge.index(3)
                M_insertSM= self.LCD1.Feld_Reihenfolge[M_insert_findS + 1]
                M_stelle= self.LCD1.Feld_Reihenfolge.index(M_insertSM)

                print", einfügen bei index",M_stelle
                self.LCD1.Feld_Reihenfolge.insert(M_stelle,S_nr)
                print "Feld", self.LCD1.Feld_Reihenfolge,
                print "Einfügen vor Wert",M_insertSM," mit Index", self.LCD1.Feld_Reihenfolge.index(M_insertSM)

        else:#                  SM-Anzahl (0)
            print" " + str((S_nr==12 and "nicht vorhanden"))
            if M_Etage<>"":
                print", lösche Script '"+ str(S_nr) +"'", self.LCD1.Feld_Reihenfolge.remove(S_nr)
                print "Feld_Reihenfolge =", self.LCD1.Feld_Reihenfolge
                S_Zusatz=0


    def MEM_clear(self):
        zeile =[0] * self.maxX
        self.screen = [zeile[:] for y in range(0, self.maxY/ 2)]



    def Licht(self, wert):
        erg= self.IMP.GPIO.output(self.lichtPin, wert)

    def get_Licht(self):
        return(self.IMP.GPIO.input(self.lichtPin))


    def point(self, *parameter):
        self.posX, self.posY = parameter[0:2]

        if len(parameter) > 2:#          sichtbar (1) oder nicht (0)
            par3 = (parameter[2])

            if par3 == 1:
                YP, YPZ= divmod(self.posY, 2)

                Dwert= self.screen[int(YP)][int(self.posX)]
                altwert = 0

                grau = self.penstat << self.shift#      LCDwerte[0] = shift
                if YPZ == 1:
                    grau = grau << 4

                if self.penstat in range(1,2**(4- self.shift)):#  max graustufen
                    Dwert = Dwert | grau

                elif self.penstat == 0:
                    grau = 0x0f & (2**(4- self.shift)-1) << self.shift
                    if YPZ == 1:
                        grau = grau << 4
                    grau = 0xff ^ grau
                    Dwert = Dwert & grau

                elif self.penstat == -1:
                    grau = 0x0f & (2**(4- self.shift)-1) << self.shift
                    if YPZ == 1:
                        grau = grau << 4
                    Dwert = Dwert ^ grau

                self.screen[int(YP)][int(self.posX)] = Dwert

    def pen(self, *wertLine):
        if wertLine[0] in range(-1, 2**(4-self.shift)):#       (-1 bis  max-graustufen)
            self.penstat = wertLine[0]
        else:
            print "Nur -1, 0 bis 3 für 'pen' zulässig"#	-1 = invertieren, 0 = Weiß, 1 = hellgrau, 2 = dunkelgrau, 3 = schwarz


    def get_Pen(self):
        return self.penstat


    def get_Screen(self, Xstart=0, Ystart=0, Xende=79, Yende=127):
        for x in range(Ystart, Yende):
            Gzeile= self.screen[x][Xstart: Xende]
            zeile1=[]
            zeile2=[]
            for y in Gzeile:
                zeile2.append(((y & 0xf0) >> 4) >> self.shift)
                zeile1.append((y & 0x0f) >> self.shift)

            sammel=""
            for y in zeile1:
                sammel += y>= 4 and "W" or y== 3 and "@" or y== 2 and "o" or y== 1 and "." or " "
            print sammel + "<"

            sammel=""
            for y in zeile2:
                sammel += y>= 4 and "W" or y== 3 and "@" or y== 2 and "o" or y== 1 and "."  or " "
            print sammel + "<"


    def line(self, *parameter):
        startX, startY = parameter[0:2]
        endX, endY = parameter[2:4]
#        print"posline:", startX, startY, endX, endY
        self.point(startX, startY)

        difX = endX - startX
        difY = endY - startY

        MaxWeit = abs(difX)
        if abs(difY) > abs(difX):
            MaxWeit = abs(difY)

        if abs(difX) < .001:
            addX=difX
        else:
            addX = difX * 1.0 / MaxWeit * 1.0

        if abs(difY) < .001:
            addY = difY
        else:
            addY = difY * 1.0 / MaxWeit * 1.0


        for z in range(0, MaxWeit+1):#######   neu +1

            erg= divmod(startY, 2)
            YP= int(erg[0])
            YPZ= int(erg[1])

            if (startY >= 0 and startY < self.maxY) and \
               (startX >= 0 and startX < self.maxX): 
                Dwert= self.screen[int(YP)][int(startX+ .5)]

                grau = self.penstat << self.shift#      LCDwerte[0] = shift
                if YPZ == 1:
                    grau = grau << 4

                if self.penstat in range(1,2**(4- self.shift)):#  max graustufen
                    Dwert = Dwert | grau

                elif self.penstat == 0:
                    grau = 0x0f & (2**(4- self.shift)-1) << self.shift
                    if YPZ == 1:
                        grau = grau << 4
                    grau = 0xff ^ grau
                    Dwert = Dwert & grau

                elif self.penstat == -1:
                    grau = 0x0f & (2**(4- self.shift)-1) << self.shift
                    if YPZ == 1:
                        grau = grau << 4
                    Dwert = Dwert ^ grau

                self.screen[int(YP)][int(startX + .5)] = Dwert

            startX += addX
            startY += addY

        self.posX = endX
        self.posY = endY


    def lineR(self, *parameter):
        startX = self.posX
        startY = self.posY
        difX, difY = parameter[0:2]

        MaxWeit = abs(difX)
        if abs(difY) > abs(difX):
            MaxWeit = abs(difY)

        if abs(difX) < .001:
            addX=difX
        else:
            addX = difX * 1.0 / MaxWeit * 1.0

        if abs(difY) < .001:
            addY = difY
        else:
            addY = difY * 1.0 / MaxWeit * 1.0

        self.posX = startX + difX
        self.posY = startY + difY

        for z in range(0,MaxWeit):
            startX += addX
            startY += addY
            erg= divmod(startY, 2)
            YP= int(erg[0])
            YPZ= int(erg[1])

            if startY >= 0 and startY < self.maxY and \
               (startX >= 0 and startX < self.maxX): 
                Dwert= self.screen[int(YP)][int(startX + .5)]

                grau = self.penstat << self.shift#      LCDwerte[0] = shift
                if YPZ == 1:
                    grau = grau << 4

                if self.penstat in range(1,2**(4- self.shift)):#  max graustufen
                    Dwert = Dwert | grau

                elif self.penstat == 0:
                    grau = 0x0f & (2**(4- self.shift)-1) << self.shift
                    if YPZ == 1:
                        grau = grau << 4
                    grau = 0xff ^ grau
                    Dwert = Dwert & grau

                elif self.penstat == -1:
                    grau = 0x0f & (2**(4- self.shift)-1) << self.shift
                    if YPZ == 1:
                        grau = grau << 4
                    Dwert = Dwert ^ grau

                self.screen[int(YP)][int(startX + .5)] = Dwert



    def box(self, *parameter):
        if len(parameter) <=4 or len(parameter) == 5 and parameter[4]== 0:
            for x in range(0,4):#               Keine Füllung
                Xs= parameter[self.Lfolge[x][0]]
                Ys= parameter[self.Lfolge[x][1]]
                Xe= parameter[self.Lfolge[x][2]]
                Ye= parameter[self.Lfolge[x][3]]
                self.line(Xs, Ys, Xe, Ye)

        if len(parameter) >= 5 and parameter[4]== 1:#    *** MIT Füllung ***
            Xs, Ys, Xe, Ye = parameter[0:4]

            if Xs > Xe:
                XsB=Xe
                XeB=Xs
            else:
                XsB=Xs
                XeB=Xe

            if Ys > Ye:
                YsB = Ye
                YeB = Ys
            else:
                YsB = Ys
                YeB = Ye

            for lineY in range (int(YsB),int(YeB)+1):
                self.line(XsB, lineY, Xe, lineY)
        self.posX = Xs
        self.posY = Ys


    def circle(self, *parameter):
        startX, startY, radius = parameter[0:3]

        wert = self.IMP.pi / 180.0
        for x in range (0,360, 1):
            addX = self.IMP.sin(x * wert) * radius * 1.0
            addY = self.IMP.cos(x * wert) * radius * 1.0

            punktX = startX + addX
            punktY = startY + addY
            YP, YPZ= divmod(punktY, 2)

            if startY>= 0 and startY< self.maxY and (startX>= 0 and startX< self.maxX):
                Dwert= self.screen[int(YP)][int(punktX+.5)]

                grau = self.penstat << self.shift#      LCDwerte[0] = shift
                if YPZ == 1:
                    grau = grau << 4

                if self.penstat in range(1,2**(4- self.shift)):#  max graustufen
                    Dwert = Dwert | grau

                elif self.penstat == 0:
                    grau = 0x0f & (2**(4- self.shift)-1) << self.shift
                    if YPZ == 1:
                        grau = grau << 4
                    grau = 0xff ^ grau
                    Dwert = Dwert & grau

                elif self.penstat == -1:
                    grau = 0x0f & (2**(4- self.shift)-1) << self.shift
                    if YPZ == 1:
                        grau = grau << 4
                    Dwert = Dwert ^ grau

                self.screen[int(YP)][int(punktX+.5)] = Dwert

        ####################### fill  ##########################
        if len(parameter) >3:#                  FILL-Funktion
            XaddC = startX
            YaddC = startY
            radC = radius
            stepC = 1

            for x in range (0, 180 + stepC, stepC):
                Sx = self.IMP.sin(x/180.0 * self.IMP.pi)
                Cx = self.IMP.cos(x/180.0 * self.IMP.pi)
                X1 = XaddC +int(Sx*radC+.5)
                X2 = XaddC + int(Sx*(radC*-1)-.5)

                self.line(X1, YaddC + int(Cx*radC), X2, YaddC + int(Cx*radC))

        self.posX = startX
        self.posY = startY


    def TextG(self, Text_raw, Zeile=1, Spalte=1):#      Direkt auf LCD
        if self.FONT.Name != "r5x8":
            self.FONT.font(2)
            print "Neuer Font:",self.FONT.Name

        Text = Text_raw.replace("\xfc","ü")#    HM ü durch RPI ü ersetzen
        daten_1=[]
        daten_2=[]
        daten_3=[]
        daten_4=[]
        Z_add=False
        for zeichen in Text:#     Einzelzeichen separieren
            Soz = self.Szei(zeichen)
            if len(daten_1) < self.maxX:
                if Z_add == True:
                    zeichen= Zalt + zeichen
                if Soz > 0:
                    Z_add=True
                    Zalt = zeichen
                    continue
                else:
                    Z_add=False
                    S_Bytes = self.FONT.Daten[zeichen]
#                    print"bytes:", S_Bytes
                    for Dbyte in S_Bytes:#   Datenbytes extrahieren und in sammler zusammenfügen

                        for schlei in range(1,5):
                            B_erg = 0
                            for x in range (0, 2):
                                B_dat = (Dbyte & 2 ** x) >> x
                                if B_dat:
                                    B_erg = B_erg | 2 ** (x * 4) << 2
                                    B_erg = B_erg | 2 ** (x * 4 +1) << 2
                            Dbyte = Dbyte >> 2
                            if schlei == 1:
                                daten_1.append(B_erg)
                            elif schlei == 2:
                                daten_2.append(B_erg)
                            elif schlei == 3:
                                daten_3.append(B_erg)
                            elif schlei == 4:
                                daten_4.append(B_erg)

            else:
                break
            daten_1.append(0)#        Zwischenraum an Zeichenende anfügen
            daten_2.append(0)
            daten_3.append(0)
            daten_4.append(0)

        for schlei in range (0, 4):
            Tzeile = (Zeile-1)*4 + schlei
            Tlsb = Tzeile %16
            Tmsb = Tzeile // 16
            self.IMP.GPIO.output(self.RS,0)
            antwort= self.SPI.xfer2([0x60 | Tlsb, 0x70 | Tmsb])  #    Setze Zeile (Page)
            antwort= self.SPI.xfer2([0x00, 0x10])             #    Column 0
            self.IMP.GPIO.output(self.RS,1)
            if schlei ==0 :
                antwort= self.SPI.xfer2(daten_1)
            elif schlei ==1 :
                antwort= self.SPI.xfer2(daten_2)
            elif schlei ==2 :
                antwort= self.SPI.xfer2(daten_3)
            elif schlei ==3 :
                antwort= self.SPI.xfer2(daten_4)
            self.IMP.GPIO.output(self.RS,0)


    def Szei(self, zeichen):
        SoZ = 0
        for x in zeichen:
            if ord(x) > 190:
                SoZ += 1
        return SoZ


    def char(self, *parameter):

        if self.FONT.Name[0] !="v":
            ### print "wechsel Zeichensatz!"
            self.FONT.font(4)
            if self.FONT.Name == "-1":
                print "Zeichensatz kann nicht geladen werden. Abbruch!"
                exit
        SoZ = ""

        self.par0 = parameter[0]#            Parameter 0: Text
        Zbreit = self.FONT.Daten["ZB"]#    Zsatz["ZB"]

        for x in self.par0:
            if ord(x) < 128 or len(SoZ)  >0:# Sonderzeichen (Unicode) finden, verarbeiten
                if len(SoZ) >0:
                    xg = SoZ + x
                    SoZ = ""
                else:
                    xg = x

                if  xg in self.FONT.Daten:#    Zsatz:#            Einzelne Zeichen bearbeiten
                    backX = self.posX
                    backY = self.posY
                    Spen=False
                    zeichen = self.FONT.Daten[xg]# Zsatz[xg]

                    parNr=0
                    while parNr < len(zeichen):#        ZeichenBewegungen bearbeiten
                        wert1=zeichen[parNr]

                        if type(wert1) is str:
                            if wert1 == "I":#               "I" - Stift 'senken'
                                Spen = True
                                self.point(self.posX, self.posY,1)
                            elif wert1 == "H":#              "H" - Stift 'heben'
                                Spen = False
                            else:
                                print "Befehl wird nicht unterstützt (%c)"% wert1
                        else:#                              Stift 'bewegen'
                            parNr += 1
                            wert2 = zeichen[parNr]

                            if Spen == False:#  ----------  "H" = nur neue Koordinaten
                                if self.Tdir == 0:#            dir 0 = 0°
                                    self.posX += int(wert1)
                                    self.posY += int(wert2)*-1

                                elif self.Tdir == 1:#            dir 1 = 90°
                                    self.posX += wert2 * -1
                                    self.posY += wert1 * -1

                                elif self.Tdir == 2:#            dir 2 = 180°
                                    self.posX += int(wert1)*-1
                                    self.posY += int(wert2)

                                elif self.Tdir == 3:#            dir 3 = 270°
                                    self.posX += wert2
                                    self.posY += wert1
                                else:
                                    print"'dir(%1d)' wird nicht unterstützt" % dirStat

                            else:#             -----------  "I" = Linie zeichnen

                                if self.Tdir == 0:#           dir 0 = 0°
                                    Lx = wert1
                                    Ly = wert2 * -1

                                elif self.Tdir == 1:#           dir 1 = 90°
                                    Lx = wert2 * -1
                                    Ly = wert1 * -1

                                elif self.Tdir == 2:#          dir 2 = 180°
                                    Lx = wert1 * -1
                                    Ly = wert2

                                elif self.Tdir == 3:#           dir 3 = 270°
                                    Lx = wert2
                                    Ly = wert1

                                else:
                                    print "Zeichen-Richtung %d wird nicht unterstützt" %(dirStat)
                                    break

                                self.lineR(Lx,Ly)
                        parNr += 1

                    if self.Tdir == 0:
                        neuX = backX + Zbreit
                        neuY = backY

                    if self.Tdir == 1:
                        neuX = backX
                        neuY = backY - Zbreit

                    if self.Tdir == 2:
                        neuX = backX - Zbreit
                        neuY = backY

                    if self.Tdir == 3:
                        neuX = backX
                        neuY = backY + Zbreit

                    self.posX = neuX
                    self.posY = neuY

                else:
                    print x, ord(x) ,"nicht enthalten"
            else:
                SoZ = x


    def dirT(self, dir):#   DIR 0= WO, 1= NS, 2= OW, 3= SN
        if dir in range(0, 4):
            Tdir = dir
        else:
            print " Nur 0, 1, 2, oder 3 für Richting zulässig: ",dir


    def get_Tdir(self):#    Text-Richtung
        return self.Tdir


    def HM_monitor(self, S_Anz_Art):
        ###################################   Start   ################################
        self.Feld_Reihenfolge=[1,8,11,2,7,3,9]
        M_Art_max= len (self.Feld_Reihenfolge) + self.ArtMax_add    #        Anfängliche Anzahl von 'Feld_Reihenfolge'

        self.M_LiG_Zusatz= 0
        self.M_FeG_Zusatz= 0
        self.M_RoG_Zusatz= 0

        M_Licht_Etage=""
        M_Fenster_Etage=""
        M_Rollo_Etage=""

        self.zaehler= 0
        self.HM_NoData= 0
        self.F_REQ_data= 0
       
        from HM_Scripts_neu import HM_scripts as HMs

        #           [Py-Funktion, HM-Script, Lauf-Nr]
        Feld_Daten = [PYS1.script.Script1,HMs["HM_Script1"],1],[PYS1.script.Script2,HMs["HM_Script2"],2],\
                     [PYS1.script.Script3,HMs["HM_Script3"],3],[PYS1.script.Script2_1_LiG,HMs["HM_Script2_1_LiG"],4],\
                     [PYS1.script.Script2_2_FeG,HMs["HM_Script2_2_FeG"],5],\
                     [PYS1.script.Script2_3_RoG,HMs["HM_Script2_3_RoG"],6],\
                     [PYS1.script.Script4,HMs["HM_Script4"],7],[PYS1.script.Script5,HMs["HM_Script5_TDA"],8],\
                     [PYS1.script.Script6,HMs["HM_Script6_ALARM"],9],[PYS1.script.Script7_nix,"SchleifenAnzeige",10],\
                     [PYS1.script.Script8,HMs["HM_Script8_tmpDG"],11],\
                     [PYS1.script.Script9,HMs["HM_Script9_SerM"],12]

        M_insert_find= self.Feld_Reihenfolge.index(2)
        self.M_insertFLR= self.Feld_Reihenfolge[M_insert_find+1]

        if self.LCD1.config["ErrAnz"]== "1":#    ErrAnz:
            self.Feld_Reihenfolge.insert(len(self.Feld_Reihenfolge)-1,10)

        min_alt="99"
        M_quit = False
        self.TASTE.taste = False

        self.LCD1.MEM_clear()
        print"Daten"
        while not M_quit:
            self.Tstart= self.IMP.time.time()
            self.IMP.time.sleep(.1)
            min_neu= self.TimeLine("%M")

            if min_alt <> min_neu:
                print"Wechsel: ", min_alt, "->", min_neu
                min_alt = min_neu

                print "Reihenfolge:",S_Anz_Art,
                M_folge= self.Feld_Reihenfolge[S_Anz_Art-1]-1
                ablauf = Feld_Daten[M_folge]
                print "Script:",ablauf[2]

                if ablauf[1]=="SchleifenAnzeige":
                    ziel=ablauf[0]
#                    print"Ziel:", ziel
                    S_ret=ziel(PYS1, LCD1)
                else:
                    M_socket=self.Status_ALLE(LCD1,ablauf[1],ablauf[0])
    #                print"M_socket=", M_socket

                    if type(M_socket) in (tuple, str):#     != "OK":
                        print "Rückgabewert von M_socket ist Fehler (M_socket):",M_socket
                        print "Länge von M_socket ist:",len(M_socket)
                        for M_s in M_socket:
                            print M_s
                            if "Fehler" in str(M_s):
                                M_ret=SocketFehler_list(M_socket)
                                exit
                    if 1 ==2:
                        if type(M_socket) is str:
                                SocketFehler_str(M_socket)
                                exit

                    if ablauf[2]==2:
                        antwort=self.LCD1.Zusatz_FLR(4,LCD1.M_LiG_Zusatz)  #Licht
                        antwort=self.LCD1.Zusatz_FLR(5,LCD1.M_FeG_Zusatz)  #Fenster
                        antwort=self.LCD1.Zusatz_FLR(6,LCD1.M_RoG_Zusatz)  #Rollos
                        print""

                    if ablauf[2]==3:
                        antwort=self.LCD1.Zusatz_SM(12,self.LCD1.M_SM_Zusatz)  #ServiceMeldungen
                        print""

    #               print "\tM_socket == socket:",type(M_socket) == socket._socketobject
                    if type(M_socket) == self.IMP.SOC._socketobject:#     socket!:
                        Script_final(M_socket)

                print"Zähler: (%5u)   No_Data: (%5u)   REQ-Data: (%5u) " % (self.zaehler, self.HM_NoData, self.F_REQ_data)
                self.zaehler +=1

                S_Anz_Art += 1
                if S_Anz_Art > len(self.Feld_Reihenfolge):
                    S_Anz_Art = 1

            if self.TASTE.taste:
                TD= self.TASTE.Tdauer
                print "Taste >> ",
                print  "Dauer: %6.3f" % (TD),

                if self.TASTE.taste== self.LCD1.T1:
                    if TD > .05:
                        if TD < .15:
                            print "kurz (LCD-Licht)"
                            self.LCD1.lichtAN = not self.LCD1.lichtAN
                            self.LCD1.Licht(self.LCD1.lichtAN)  # LCD-Beleuchtung umschalten
                        elif TD < .9:
                            print "mittel"
                            min_alt = "99"
                        else:
                            print "LANG"
                            M_quit = True
                    else:
                        print
                self.TASTE.taste= False

        self.LCD1.LCD_clear()
        print"ENDE"

    def TimeLine(self, template="%d.%m.%Y %H:%M"):
        return self.IMP.time.strftime(template)


    def Status_ALLE(self, LCD1, HM_Script, Ziel):
        S_ret= HM1.Script_Start(self.LCD1.IP_addr, HM_Script)

        self.S_sock=S_ret[1]
        if S_ret[0] != "OK":
            gem.F_REQ_data +=1
            print "Status_ALLE / Fehler aufgetreten:"
            for x in S_ret:
                print x
            return S_ret


        if 1 ==2:
            if S_lang>1:
                S_ret=Script_resp(S_sock,S_lang,S_daten)
                if "Fehler 001" in S_ret:
                    return [S_sock,S_ret]

                if "Fehler" in S_ret:
                    print"Fehler bei Datenabfrage in Script_resp:", S_ret
                    print "res1:", res1
                    print"HM_Script:",HM_Script
                    gem.HM_NoData += 1
                    return "Fehler 004: HM liefert keine Daten (auf korrekt beantwortete Anfrage)"

                if  not S_ret:
                    print"Ziel/ S_ret",Ziel,S_ret
                    print"S:ret-Länge <1!"
                    return "Fehler: HM liefert keine Daten (auf korrekt beantwortete Anfrage"

        print "print SRet:",S_ret[2]
        S_ret=Ziel(self, LCD1, S_ret[2])

        antwort=self.SPI.xfer2([0x0C])  # 0x0C = LCD ein, Kursor aus, Blinken aus

    def Gprint(self, Text, istX, istY):
        if FONT.Name[0] != "r":
            print"R-Zeichensatz erforderlich! Abbruch!"
            quit

        maxBitY = 18#   14
        LCD1.pen(3)
        SoZ = ""

        for z in Text:#           Einzelzeichen aus (Text) behandeln
            if ord(z) < 128 or len(SoZ) >0:
                if len(SoZ) >0:
                    z = SoZ + z
                    SoZ = ""
                datZeile = FONT.Daten[z]
                maxWert =max(datZeile)

                for werte in datZeile:#          Zeichen-Einzeldaten bearbeiten

                    for bitanz in range(0,maxBitY):#    14):
                        YP= ((istY+bitanz) // 2)
                        YPZ = ((istY+bitanz) % 2)
                        Dwert = LCD1.screen[int(YP)][istX]
                        bitwert = (werte & (2** bitanz)) >> bitanz
                        if bitwert:
                            grau = 0x0f & (2**(4- LCD1.shift)-1) << LCD1.shift#      LCDwerte[0] = shift
                            if YPZ == 1:
                                grau = grau << 4
                            Dwert = Dwert | grau
                        LCD1.screen[int(YP)][istX] = Dwert

                    istX += 1
                istX += 1
            else:
                SoZ = z
###        LCD1.display()
