# -*- coding: utf-8 -*-
class PICO:
    def __init__(self, IMP, LCD1, FONT):
        self.IMP= IMP
        self.LCD1= LCD1
        self.FONT= FONT
        
        self.Stimeout= [20, 10, 15, 5]

        self.query=("GET /api/dxs.json?dxsEntries=251658754&dxsEntries=251659010&dxsEntries=251659266&dxsEntries=251659278&dxsEntries=251659279&dxsEntries=251658753&dxsEntries=251658496&dxsEntries=251659009&dxsEntries=251659265&dxsEntries=251659280&dxsEntries=251659281",
               "GET /api/dxs.json?dxsEntries=33556736&dxsEntries=67109120&dxsEntries=83888128&dxsEntries=16780032&?dxsEntries=33555202&dxsEntries=33555201&dxsEntries=33555203",
               "GET /api/dxs.json?dxsEntries=67109120&dxsEntries=67110400&dxsEntries=67110656&dxsEntries=67109378&dxsEntries=67109377&dxsEntries=67109379&dxsEntries=67109634&dxsEntries=67109633&dxsEntries=67109635&dxsEntries=67109890&dxsEntries=67109889&dxsEntries=67109891",
               "GET /api/dxs.json?dxsEntries=67110144&sessionId=232859340") 

        self.Qrumpf=""" HTTP/1.1
            Host: 192.168.178.57
            User-Agent: Mozilla/5.0 (X11; Linux armv7l; rv:38.0) Gecko/20100101 Firefox/38.0 Iceweasel/38.8.0
            Accept: application/json, text/plain, */*
            Accept-Language: de,en-US;q=0.7,en;q=0.3
            Accept-Encoding: gzip, deflate
            DNT: 1
            Referer: http://192.168.178.57/
            Cookie: language=de_DE
            Connection: keep-alive \n\r\n\r\n"""

        self.tabelle={251658754:"Ertrag (Tag) [Wh]",251659010:"Hausverbrauch (Tag) [kWh]",251659266:"Eigenverbrauch (Tag) [kWh]",
                 251659278:"EigenVerbrauch Quote (Tag)",251659279:"Aurarkiegrad (Tag) [%]",251658753:"Ertrag (ges) [kWh]",
                 251658496:"Betriebszeit (ges) [h]",251659009:"Hausverbrauch (ges) [kWh]",
                 251659265:"Eigenverbrauch (ges) [kWh]",251659280:"eigenVerbrQuote (ges) [%]",
                 251659281:"Aurarkiegrad [%]",
                 33556736:"DC Eingang gesamt",67109120:"DC Ausgangsleistung",
                 83888128:"DC Eigenverbrauch",16780032:"Bertiebsstatus",
                 33555202:"Spannung (DC 1 Eingang)",33555201:"Strom (DC 1 Eingang)",
                 33555203:"Leistung (DC 1 Eingang)",
                 67109120:"Ausgangsleistg (Netz akt.)",67110400:"Frequenz (Netz akt.)",
                 67110656:"Cos Phi (Netz akt.)",67110144:"Abgeregelt auf (Netz akt.)",
                 67109378:"Phase 1 (U  ) (Netz akt.)",67109377:"Phase 1 ( I ) (Netz akt.)\t",
                 67109379:"Phase 1 (  P) (Netz akt.)\t\t",67109634:"Phase 2 (U  ) (Netz akt.)",
                 67109633:"Phase 2 ( I ) (Netz akt.)\t",67109635:"Phase 2 (  P) (Netz akt.)\t\t",
                 67109890:"Phase 3 (U) (Netz akt.)",67109889:"Phase 3 ( I ) (Netz akt.)\t",
                 67109891:"Phase 3 (  P) (Netz akt.)\t\t"}

        self.bereichTxt=["Statistik: Tag/ Gesamt","Leistungswerte DC",
                    "Netz akt.(Leistung/ Frequenz/ Cos Phi/ Phase 1, 2, 3  (U|I|P)",
                    "Netz akt. (Abregelung)"]

        self.IP_addr= LCD1.config["WRip"]
        print"Wechselrichter IP-Adresse:", self.IP_addr

    def opensoc(self, x):
        soc= self.IMP.SOC.socket(self.IMP.SOC.AF_INET, self.IMP.SOC.SOCK_STREAM)
        soc.settimeout(self.Stimeout[x])
        return soc


    def holdaten(self, query, daten, Qrumpf, loop):
        Zlang= 70
        text=self.bereichTxt[loop]
        Tlang= len(text)+6
        add= (Zlang-Tlang) / 2
        print "="* add + "   "+ text + "   " + "="* add

        s= self.opensoc(loop)
        try:
###            print"IP-adr:", self.IP_addr
            s.connect((str(self.IP_addr), 80))#          Pico 4.2
###            print"Socket erstellt"

        except s.socket.error, msg:
            print"Fehler bei Socket-Erstellung aufgetreten", msg
            print "break"
            quit(1)

        if loop== "xxx":# Für Anzeige=  0
            print"-" * 30
            print "PeerName:", s.getpeername()
            print "Sock-Name", s.getsockname()
            print "FileNo", s.fileno()
            print "Timeout", s.gettimeout()
            print"-" * 30
        rweS = s.send(daten + Qrumpf)

###        print"senden  Bytes:",rweS,
        self.IMP.time.sleep(.01)
        respond = s.recv(128)#     *** response auf Anfrage

        urlerg = respond
        while respond!="":
            respond = s.recv(128)#     *** response auf Anfrage
            urlerg += respond
        loop += 1

        findHTTP=urlerg.find("\r\n\r\n")
        pico_datroh= urlerg[findHTTP+4:].replace("null","'leer'")
        pico_dat= eval(pico_datroh)
###        print"s-close"
        s.close()
        del(s)
        return pico_dat

    def anzeige(self, pico_dat):
        DCpos=((75,18), 28, 38, 48, 58, 68, 78)
        ACpos=((180,18),25, 33)
        STpos=((4,117),62)
        PHpos=((156,65), 186, 216, (138,75), 168, 198, (138,85), 168, 198)
        
        for x in pico_dat:
            if x =="status":
                Sdict= pico_dat[x]
                if Sdict["code"] != 0:
                    print "\t>>>>>>> Fehler aufgetreten! <<<<<<<"
            elif x== "dxsEntries":
                for werte in pico_dat[x]:
                    Wdict= werte
                    Dkey=Wdict['dxsId']
###                    print self.tabelle[Wdict['dxsId']].ljust(35,"."),Wdict['value']#, tabelle[Wdict['dxsId']]
                    if Dkey== 33556736:#          ======   DC   ======
                        self.LCD1.point(DCpos[0][0], DCpos[0][1])
                        self.LCD1.char("%6.1f" % (Wdict['value']))
                    if Dkey== 67109120:
                        self.LCD1.point(DCpos[0][0], DCpos[1])
                        self.LCD1.char("%6.1f" % (Wdict['value']))
                    elif Dkey== 33555202:
                        self.LCD1.point(DCpos[0][0], DCpos[2])
                        self.LCD1.char("%6.1f" % (Wdict['value']))
                    elif Dkey== 33555201:
                        self.LCD1.point(DCpos[0][0], DCpos[3])
                        self.LCD1.char("%6.1f" % (Wdict['value']))
                    elif Dkey== 33555203:
                        self.LCD1.point(DCpos[0][0], DCpos[4])
                        self.LCD1.char("%6.1f" % (Wdict['value']))
                    elif Dkey== 16780032:
                        self.LCD1.point(DCpos[0][0], DCpos[5])
                        self.LCD1.char("%6i" % (Wdict['value']))

                    elif Dkey== 251658496:
                        self.LCD1.point(DCpos[0][0], DCpos[6])
                        self.LCD1.char("%6i" % (Wdict['value']))

                    elif Dkey== 67109120:#          ======   AC   ======
                        self.LCD1.point(ACpos[0][0], ACpos[0][1])
                        self.LCD1.char("%6.1f" % (Wdict['value']))
                    elif Dkey== 67110400:
                        self.LCD1.point(ACpos[0][0], ACpos[1])
                        self.LCD1.char("%9.3f" % (Wdict['value']))
                    elif Dkey== 67110656:
                        self.LCD1.point(ACpos[0][0], ACpos[2])
                        self.LCD1.char("%9.3f" % (Wdict['value']))

                    elif Dkey== 251658754:#         =====   Statistik   =====
                        self.FONT.font(2)
                        self.LCD1.point(STpos[0][0], STpos[0][1])
                        self.LCD1.char("%6.3f" % (Wdict['value']/1000))
                        self.FONT.font(3)
                    elif Dkey== 251658753:
                        self.FONT.font(2)
                        self.LCD1.point(STpos[1], STpos[0][1])
                        self.LCD1.char("%6.1f" % (Wdict['value']))
                        self.FONT.font(3)

                    elif Dkey== 67109378:#          =====   Phase 1   =====
                        self.LCD1.point(PHpos[0][0], PHpos[0][1])
                        self.LCD1.char("%5.1f" % (Wdict['value']))
                    elif Dkey== 67109377:
                        self.LCD1.point(PHpos[0][0], PHpos[3][1])
                        self.LCD1.char("%6.2f" % (Wdict['value']))
                    elif Dkey== 67109379:
                        self.LCD1.point(PHpos[0][0], PHpos[6][1])
                        self.LCD1.char("%5.1f" % (Wdict['value']))

                    elif Dkey== 67109634:#          =====   Phase 2   =====
                        self.LCD1.point(PHpos[1], PHpos[0][1])
                        self.LCD1.char("%5.1f" % (Wdict['value']))
                    elif Dkey== 67109633:
                        self.LCD1.point(PHpos[1], PHpos[3][1])
                        self.LCD1.char("%6.2f" % (Wdict['value']))
                    elif Dkey== 67109635:
                        self.LCD1.point(PHpos[1], PHpos[6][1])
                        self.LCD1.char("%5.1f" % (Wdict['value']))
     
                    elif Dkey== 67109890:#          =====   Phase 3   =====
                        self.LCD1.point(PHpos[2], PHpos[0][1])
                        self.LCD1.char("%5.1f" % (Wdict['value']))
                    elif Dkey== 67109889:
                        self.LCD1.point(PHpos[2], PHpos[3][1])
                        self.LCD1.char("%6.2f" % (Wdict['value']))
                    elif Dkey== 67109891:
                        self.LCD1.point(PHpos[2], PHpos[6][1])
                        self.LCD1.char("%5.1f" % (Wdict['value']))

            else:
                print x, pico_dat[x]
                
            self.FONT.font(2)
            self.LCD1.point(120,117)
            self.LCD1.char(self.IMP.time.strftime("%d.%m.%Y / %H:%M"))
            self.FONT.font(3)
            self.LCD1.display()
        self.IMP.time.sleep(.01)
        print "==========   block   =========="

    def formular(self):
        #######################    LCD-Formular erzeugen
        xstart= 5#     0
        ystart= 8#  5
        yadd= 10#   8
        self.LCD1.pen(3)
        self.FONT.font(2)
        ########   DC-Werte
        self.LCD1.point(xstart+ 20, ystart-3)
        self.LCD1.char("DC-Werte"); ystart += yadd
        self.FONT.font(3)
        for text in ("Eingang [Wh]", "Ausgang [Wh]","Spannung [V]","Strom [A]",
                     "Leistung [Wh]", "Betriebsstat.", "Betriebsstd."):
            self.LCD1.point(xstart, ystart)
            self.LCD1.char(text);ystart += yadd
        #self.LCD1.box(0,8, 102,69)
        self.LCD1.box(0,10, 102,83)

        xstart= 115
        ystart= 5
        yadd=8
        self.LCD1.pen(3)
        self.FONT.font(2)
        ########   AC-Werte
        self.LCD1.point(xstart+ 20, ystart)
        self.LCD1.char("AC-Werte"); ystart += yadd
        self.FONT.font(3)
        for text in ("Ausgang [Wh]","Frequenz [Hz]","Cos Phi"):
            self.LCD1.point(xstart, ystart+5)
            self.LCD1.char(text);ystart += yadd
        self.LCD1.box(110,10, 219,39)


        xstart= 138#    0
        ystart= 55# 75# 60
        xmulti= 30
        yadd= 10
        ########   AC-Werte je Phase
        for x in xrange(1,4):
            self.LCD1.point(xstart+(x* xmulti), ystart)
            self.LCD1.char("L"+ str(x))

        for text in ("Spannung", "Strom", "Leistung"):
            self.LCD1.point(xstart-25, ystart+yadd)# *2)
            self.LCD1.char(text);ystart += yadd
        #self.LCD1.box(101,66, 230,120)
        self.LCD1.box(109,46, 238,90)

        xstart= 5#  0
        ystart= 92# 75# 60
        yadd=10
        xadd= 50
        self.LCD1.pen(3)
        self.FONT.font(2)
        ########   Statistik
        self.LCD1.point(xstart+ 20, ystart)
        self.LCD1.char("Ertrag"); ystart += yadd+4

        self.LCD1.point(130,102)
        self.LCD1.char("Datum / Zeit")
        self.LCD1.box(108,106, 238,125)

        self.FONT.font(3)
        for text in ("Tag [kWh]","Summe [kWh]"):
            self.LCD1.point(xstart, ystart)
            self.LCD1.char(text);xstart += xadd
        #self.LCD1.box(0,83, 102,122)
        self.LCD1.box(0,97, 101,125)

###        self.LCD1.display()

