#!/usr/bin/env python
# -*- coding: utf-8 -*-

import MOD_import_20170709_2000 as imp
import MOD_files_20170709_2000 as files
import MOD_font_20170709_2000 as font
import MOD_taste_20170709_2000 as taste
import MOD_lcd_20170713_1000 as lcd
import MOD_picoWR_20170713_1000 as pico



####################   Hauptprogramm   #####################

#       ***  GPIO-Ports definieren   ****** ===== BCM =====
LCDlicht=24
RS = 25
T1= 4
T2= 18

#       ***  Klassen definieren   ***
IMP=imp.Import()
FONT= font.font()
TASTE= taste.taste(IMP)

#   moeglich=("EA DOGXL240W-7", "EA DOGL128W-6", "EA DOGXL122X-2")
LCD1= lcd.LCD("EA DOGXL240", LCDlicht, RS, T1, T2, "BCM", IMP,TASTE, FONT)
FIL1= files.files(IMP, LCD1, TASTE, None)
pico= pico.PICO(IMP, LCD1, FONT)

print "Initiiert:",LCD1.LCDtyp
print "GPIO-Pins:",LCD1.GPIO_pins()

erg= LCD1.LCDtyp
if erg != "-1":
    print "GPIO + SPI erfolgreich initialisiert"
else:
    print"LCD konnte nicht initialisiert werden"

Lret= LCD1.Licht(LCD1.lichtAN)



#   =======================   Pico WR Hauptprogramm   ============================
pico.formular()#        Leerformular auf LCD ausgeben

TASTE.taste= 4
TASTE.Tdauer= .26
weiter= True
while weiter:
    if  TASTE.taste== LCD1.T1:
        if TASTE.Tdauer< 0.25:#      LCD Licht
            LCD1.Licht(not LCD1.get_Licht())

        elif TASTE.Tdauer < 1:#      Grafikanzeige
            flag= True#                 Werte in LCD-Formular löschen
            LCD1.pen(0)
            LCD1.box(74,13, 98,80, flag)#         DC-Werte
            LCD1.box(180,13, 215,35, flag)#         AC-Werte
            LCD1.box(1,111, 97,119, flag)#         Stati-Werte
            LCD1.box(153,59, 236,87, flag)#         Phase
            LCD1.box(120,111, 227,119, flag)#         zeit
            LCD1.pen(3)
            loop=0
            print "KOSTAL Pico Wechselrichter Daten vom", IMP.time.strftime("%d.%m.%Y/ %H:%M Uhr.\n")
            for x in range(0, len(pico.query)):
                daten= pico.query[x] 

                pico_dat= pico.holdaten(pico.query, daten, pico.Qrumpf, loop)
                loop += 1
                pico.anzeige(pico_dat)
        else:#      Programmende
            weiter= False

        TASTE.taste=""
        TASTE.Tdauer=0
    IMP.time.sleep(1)
print"\nProgrammende!"

LCD1.LCD_clear()
LCD1.Licht(0)
IMP.GPIO.cleanup()


try:#       Aufräumen
    del FIL1, FONT, TASTE, LCD1, IMP, pico
except:
    print "Mindestens EIN Klassenverweis konnte nicht gelöscht werden"

quit(0)
